package com.particles.android.ads.internal.util

import android.content.Context
import com.particles.android.ads.AdFormat
import java.io.IOException

object TestModeUtils {

    fun getTestResponse(context: Context, format: String?): String? {
        val filename = when (format) {
            AdFormat.BANNER.name.lowercase() -> "test_nova_banner_ads.json"
            AdFormat.NATIVE.name.lowercase() -> "test_nova_native_ads.json"
            AdFormat.APP_OPEN.name.lowercase(),
            AdFormat.INTERSTITIAL.name.lowercase() -> "test_nova_interstitial_ads.json"
            else -> null
        }

        return filename?.let { readTextFromAsset(context, it) }
    }

    private fun readTextFromAsset(context: Context, filename: String): String? {
        return try {
            context.assets.open(filename).use {
                it.bufferedReader().readText()
            }
        } catch (e: IOException) {
            null
        }
    }
}
