package com.particles.android.ads.internal.util.viewability

import com.iab.omid.library.newsbreak1.adsession.AdSession
import com.iab.omid.library.newsbreak1.adsession.media.MediaEvents

class OMMediaEvents(adSession: AdSession) {
    private val mediaEvents: MediaEvents = MediaEvents.createMediaEvents(adSession)

    fun start(duration: Long, volume: Float) {
        try {
            mediaEvents.start(duration.toFloat(), volume)
        } catch (e: IllegalStateException) {
           // ignored
        }
    }

    fun firstQuartile() {
        try {
            mediaEvents.firstQuartile()
        } catch (e: IllegalStateException) {
           // ignored
        }
    }

    fun midpoint() {
        try {
            mediaEvents.midpoint()
        } catch (e: IllegalStateException) {
           // ignored
        }
    }

    fun thirdQuartile() {
        try {
            mediaEvents.thirdQuartile()
        } catch (e: IllegalStateException) {
           // ignored
        }
    }

    fun complete() {
        try {
            mediaEvents.complete()
        } catch (e: IllegalStateException) {
           // ignored
        }
    }

    fun pause() {
        try {
            mediaEvents.pause()
        } catch (e: IllegalStateException) {
           // ignored
        }
    }

    fun resume() {
        try {
            mediaEvents.resume()
        } catch (e: IllegalStateException) {
           // ignored
        }
    }

    fun bufferStart() {
        try {
            mediaEvents.bufferStart()
        } catch (e: IllegalStateException) {
           // ignored
        }
    }

    fun bufferFinish() {
        try {
            mediaEvents.bufferFinish()
        } catch (e: IllegalStateException) {
           // ignored
        }
    }

    fun volumeChange(volume: Float) {
        try {
            mediaEvents.volumeChange(volume)
        } catch (e: IllegalStateException) {
           // ignored
        }
    }

    fun skipped() {
        try {
            mediaEvents.skipped()
        } catch (e: IllegalStateException) {
           // ignored
        }
    }
}
