package com.particles.android.ads.nativead

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.FrameLayout
import com.particles.android.ads.internal.NativeAdImpl

class NativeAdView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : FrameLayout(context, attrs, defStyleAttr) {

    var advertiserView: View? = null
    var bodyView: View? = null
    var callToActionView: View? = null
    var headlineView: View? = null
    var iconView: View? = null
    var mediaView: MediaView? = null
    var starRatingView: View? = null
    var addonView: AddonView? = null

    private var ad: NativeAdImpl? = null
    private var isRegistered: Boolean = false

    private val adHelper by lazy { NativeAdViewHelper(this) }

    fun setNativeAd(ad: NativeAd?) {
        if (ad is NativeAdImpl) {
            if (this.ad != null) {
                tryUnregister()
            }
            this.ad = ad
            if (isAttachedToWindow) {
                tryRegister(ad)
            }
        }
    }

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        if (ad != null) {
            tryRegister(ad!!)
        }
    }

    override fun onDetachedFromWindow() {
        super.onDetachedFromWindow()
        tryUnregister()
    }

    private fun tryRegister(ad: NativeAdImpl) {
        if (!isRegistered) {
            isRegistered = true
            adHelper.register(ad)
        }
    }

    private fun tryUnregister() {
        if (isRegistered) {
            isRegistered = false
            adHelper.unregister()
        }
    }

}
