/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.browser;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewStub;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.view.NestedScrollingChild;
import com.google.android.material.appbar.AppBarLayout;
import com.particles.android.ads.R;
import com.particles.android.ads.browser.BrowserMediaHeader;
import com.particles.android.ads.browser.BrowserTracker;
import com.particles.android.ads.browser.DeeplinkHandler;
import com.particles.android.ads.internal.util.WebViews;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\u0012\u0010\u001c\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u0019H\u0014J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0019H\u0014J\b\u0010%\u001a\u00020\u0019H\u0014J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020!H\u0002J\u0012\u0010(\u001a\u00020\u00192\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010+\u001a\u00020\u0019H\u0002J\b\u0010,\u001a\u00020\u0019H\u0002J\b\u0010-\u001a\u00020\u0019H\u0002J\b\u0010.\u001a\u00020\u0019H\u0002J\b\u0010/\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/particles/android/ads/browser/BrowserActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "appBar", "Lcom/google/android/material/appbar/AppBarLayout;", "floatingStub", "Landroid/view/ViewStub;", "floatingView", "Landroid/view/View;", "loading", "mediaHeader", "Lcom/particles/android/ads/browser/BrowserMediaHeader;", "toolbar", "Landroidx/appcompat/widget/Toolbar;", "toolbarBack", "toolbarClose", "toolbarTitle", "Landroid/widget/TextView;", "tracker", "Lcom/particles/android/ads/browser/BrowserTracker;", "webProgressBar", "Landroid/widget/ProgressBar;", "webView", "Landroid/webkit/WebView;", "applyTheme", "", "hideLoading", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onOptionsItemSelected", "", "item", "Landroid/view/MenuItem;", "onPause", "onResume", "setNestedScrollingEnabled", "enabled", "setTitle", "title", "", "setupActionBar", "setupFloating", "setupLoading", "setupWebView", "showLoading", "nova-sdk_release"})
@SourceDebugExtension(value={"SMAP\nBrowserActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserActivity.kt\ncom/particles/android/ads/browser/BrowserActivity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1#2:262\n*E\n"})
public final class BrowserActivity
extends AppCompatActivity {
    private AppBarLayout appBar;
    private Toolbar toolbar;
    private View toolbarBack;
    private View toolbarClose;
    private TextView toolbarTitle;
    private WebView webView;
    private ProgressBar webProgressBar;
    private View loading;
    @Nullable
    private ViewStub floatingStub;
    @Nullable
    private View floatingView;
    @Nullable
    private BrowserTracker tracker;
    @Nullable
    private BrowserMediaHeader mediaHeader;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.applyTheme();
        super.onCreate(savedInstanceState);
        this.supportRequestWindowFeature(1);
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        BrowserMediaHeader browserMediaHeader = this.mediaHeader = BrowserMediaHeader.Companion.obtain(intent);
        boolean bl = browserMediaHeader != null ? !browserMediaHeader.getFloating() : false;
        if (bl) {
            this.setContentView(R.layout._nova_activity_ads_browser_with_media_header);
        } else {
            this.setContentView(R.layout._nova_activity_ads_browser);
        }
        this.setupActionBar();
        this.setupWebView();
        this.setupLoading();
        BrowserMediaHeader browserMediaHeader2 = this.mediaHeader;
        boolean bl2 = browserMediaHeader2 != null ? browserMediaHeader2.getFloating() : false;
        if (bl2) {
            this.setupFloating();
            View view = this.floatingView;
            ViewGroup viewGroup = view instanceof ViewGroup ? (ViewGroup)view : null;
            if (viewGroup != null) {
                ViewGroup it = viewGroup;
                boolean bl3 = false;
                BrowserMediaHeader browserMediaHeader3 = this.mediaHeader;
                if (browserMediaHeader3 != null) {
                    browserMediaHeader3.attach(it);
                }
            }
        }
        String url = this.getIntent().getStringExtra("url");
        String requestId = this.getIntent().getStringExtra("request_id");
        String adId = this.getIntent().getStringExtra("ad_id");
        String adUnitId = this.getIntent().getStringExtra("ad_unit_id");
        long adClickedAt = this.getIntent().getLongExtra("ad_clicked_at", System.currentTimeMillis());
        String adToken = this.getIntent().getStringExtra("ad_token");
        if (requestId != null && adId != null && adUnitId != null && adToken != null) {
            this.tracker = new BrowserTracker(requestId, adId, adUnitId, adClickedAt, adToken);
        }
        this.setTitle(url);
        if (WebViews.INSTANCE.isDeeplink(url)) {
            CharSequence charSequence;
            DeeplinkHandler deeplinkHandler2 = new DeeplinkHandler((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ BrowserActivity this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    WebView webView;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    BrowserActivity.access$showLoading(this.this$0);
                    BrowserTracker browserTracker = BrowserActivity.access$getTracker$p(this.this$0);
                    if (browserTracker != null) {
                        browserTracker.logPageStart();
                    }
                    if ((webView = BrowserActivity.access$getWebView$p(this.this$0)) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                        webView = null;
                    }
                    webView.loadUrl(it);
                }
            }));
            Context context = (Context)this;
            Uri uri = Uri.parse((String)url);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(...)");
            deeplinkHandler2.handle(context, uri);
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView = null;
            }
            if ((charSequence = (CharSequence)webView.getUrl()) == null || charSequence.length() == 0) {
                this.finish();
            }
        } else if (url != null) {
            WebView webView;
            this.showLoading();
            BrowserTracker browserTracker = this.tracker;
            if (browserTracker != null) {
                browserTracker.logPageStart();
            }
            if ((webView = this.webView) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView = null;
            }
            webView.loadUrl(url);
        }
    }

    private final void applyTheme() {
        this.getWindow().setStatusBarColor(this.getColor(R.color._nova_browser_bg));
    }

    private final void setupActionBar() {
        AppBarLayout appBarViewGroup = (AppBarLayout)this.findViewById(R.id.app_bar);
        if (appBarViewGroup != null) {
            appBarViewGroup.setStateListAnimator(null);
            BrowserMediaHeader browserMediaHeader = this.mediaHeader;
            if (browserMediaHeader != null) {
                browserMediaHeader.attach((ViewGroup)appBarViewGroup);
            }
        }
        Intrinsics.checkNotNull((Object)appBarViewGroup);
        this.appBar = appBarViewGroup;
        View view = this.findViewById(R.id.toolbar);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.toolbar = (Toolbar)view;
        Toolbar toolbar = this.toolbar;
        if (toolbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            toolbar = null;
        }
        View view2 = toolbar.findViewById(R.id.toolbar_back);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.toolbarBack = view2;
        Toolbar toolbar2 = this.toolbar;
        if (toolbar2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            toolbar2 = null;
        }
        View view3 = toolbar2.findViewById(R.id.toolbar_close);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
        this.toolbarClose = view3;
        Toolbar toolbar3 = this.toolbar;
        if (toolbar3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            toolbar3 = null;
        }
        View view4 = toolbar3.findViewById(R.id.toolbar_title);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(...)");
        this.toolbarTitle = (TextView)view4;
        View view5 = this.toolbarBack;
        if (view5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbarBack");
            view5 = null;
        }
        view5.setOnClickListener(arg_0 -> BrowserActivity.setupActionBar$lambda$1(this, arg_0));
        View view6 = this.toolbarClose;
        if (view6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbarClose");
            view6 = null;
        }
        view6.setOnClickListener(arg_0 -> BrowserActivity.setupActionBar$lambda$2(this, arg_0));
        Toolbar toolbar4 = this.toolbar;
        if (toolbar4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            toolbar4 = null;
        }
        this.setSupportActionBar(toolbar4);
        BrowserMediaHeader browserMediaHeader = this.mediaHeader;
        boolean bl = browserMediaHeader != null ? !browserMediaHeader.getFloating() : false;
        if (bl) {
            // empty if block
        }
    }

    private final void setupWebView() {
        View view = this.findViewById(R.id.progress_bar);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.webProgressBar = (ProgressBar)view;
        View view2 = this.findViewById(R.id.web_view);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.webView = (WebView)view2;
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.setWebChromeClient(new WebChromeClient(this){
            final /* synthetic */ BrowserActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public void onProgressChanged(@Nullable WebView view, int newProgress) {
                ProgressBar progressBar = BrowserActivity.access$getWebProgressBar$p(this.this$0);
                if (progressBar == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webProgressBar");
                    progressBar = null;
                }
                progressBar.setProgress(newProgress);
                ProgressBar progressBar2 = BrowserActivity.access$getWebProgressBar$p(this.this$0);
                if (progressBar2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webProgressBar");
                    progressBar2 = null;
                }
                progressBar2.setVisibility(newProgress < 100 ? 0 : 4);
                if (newProgress >= 100) {
                    BrowserActivity.access$hideLoading(this.this$0);
                    BrowserTracker browserTracker = BrowserActivity.access$getTracker$p(this.this$0);
                    if (browserTracker != null) {
                        browserTracker.logPageLoaded();
                    }
                    if (BrowserActivity.access$getMediaHeader$p(this.this$0) != null) {
                        WebView webView = view;
                        BrowserActivity.access$setNestedScrollingEnabled(this.this$0, !(webView != null ? webView.canGoBack() : false));
                    }
                }
            }

            public void onReceivedTitle(@Nullable WebView view, @Nullable String title) {
                if (title != null) {
                    this.this$0.setTitle(title);
                }
            }
        });
        WebView webView2 = this.webView;
        if (webView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView2 = null;
        }
        webView2.setWebViewClient(new WebViewClient(this){
            @NotNull
            private final DeeplinkHandler deeplinkHandler;
            final /* synthetic */ BrowserActivity this$0;
            {
                this.this$0 = $receiver;
                this.deeplinkHandler = new DeeplinkHandler((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>($receiver){
                    final /* synthetic */ BrowserActivity this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        WebView webView = BrowserActivity.access$getWebView$p(this.this$0);
                        if (webView == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                            webView = null;
                        }
                        webView.loadUrl(it);
                    }
                }));
            }

            @NotNull
            public final DeeplinkHandler getDeeplinkHandler() {
                return this.deeplinkHandler;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable WebResourceRequest request) {
                if (view == null) return false;
                if (request == null) return false;
                Context context = (Context)this.this$0;
                Uri uri = request.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getUrl(...)");
                if (!this.deeplinkHandler.handle(context, uri)) return false;
                return true;
            }

            public void onPageCommitVisible(@Nullable WebView view, @Nullable String url) {
                block0: {
                    super.onPageCommitVisible(view, url);
                    BrowserActivity.access$hideLoading(this.this$0);
                    BrowserTracker browserTracker = BrowserActivity.access$getTracker$p(this.this$0);
                    if (browserTracker == null) break block0;
                    browserTracker.logTextLoaded();
                }
            }

            public void onPageStarted(@Nullable WebView view, @Nullable String url, @Nullable Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                if (BrowserActivity.access$getMediaHeader$p(this.this$0) != null) {
                    WebView webView = view;
                    BrowserActivity.access$setNestedScrollingEnabled(this.this$0, !(webView != null ? webView.canGoBack() : false));
                }
            }

            public void onPageFinished(@Nullable WebView view, @Nullable String url) {
                super.onPageFinished(view, url);
                Object object = view;
                this.this$0.setTitle(object != null && (object = object.getTitle()) != null ? (CharSequence)object : (CharSequence)url);
            }

            public boolean onRenderProcessGone(@Nullable WebView view, @Nullable RenderProcessGoneDetail detail) {
                return WebViews.INSTANCE.onRenderProcessGone(view, detail);
            }
        });
    }

    private final void setupFloating() {
        block3: {
            View view;
            ViewStub viewStub = this.floatingStub = (ViewStub)this.findViewById(R.id.floating_stub);
            View view2 = this.floatingView = viewStub != null ? viewStub.inflate() : null;
            Object object = view2 != null ? view2.findViewById(R.id.exo_position) : null;
            if (object != null) {
                object.setVisibility(4);
            }
            View view3 = this.floatingView;
            Object object2 = view3 != null ? view3.findViewById(R.id.exo_progress) : null;
            if (object2 != null) {
                object2.setVisibility(4);
            }
            View view4 = this.floatingView;
            Object object3 = view4 != null ? view4.findViewById(R.id.exo_duration) : null;
            if (object3 != null) {
                object3.setVisibility(4);
            }
            if ((view = this.floatingView) == null || (view = view.findViewById(R.id.floating_dismiss)) == null) break block3;
            view.setOnClickListener(arg_0 -> BrowserActivity.setupFloating$lambda$7(this, arg_0));
        }
    }

    private final void setupLoading() {
        View view = this.findViewById(R.id.loading);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.loading = view;
    }

    private final void showLoading() {
        View view = this.loading;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loading");
            view = null;
        }
        view.setVisibility(0);
    }

    private final void hideLoading() {
        View view = this.loading;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loading");
            view = null;
        }
        view.setVisibility(8);
    }

    private final void setNestedScrollingEnabled(boolean enabled) {
        WebView webView;
        WebView webView2 = this.webView;
        if (webView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView2 = null;
        }
        NestedScrollingChild nestedScrollingChild = (webView = webView2) instanceof NestedScrollingChild ? (NestedScrollingChild)webView : null;
        if (nestedScrollingChild != null) {
            nestedScrollingChild.setNestedScrollingEnabled(enabled);
        }
        if (!enabled) {
            AppBarLayout appBarLayout = this.appBar;
            if (appBarLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"appBar");
                appBarLayout = null;
            }
            appBarLayout.setExpanded(false);
        }
    }

    public void setTitle(@Nullable CharSequence title) {
        TextView textView = this.toolbarTitle;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbarTitle");
            textView = null;
        }
        textView.setText(title);
    }

    protected void onPause() {
        block2: {
            super.onPause();
            BrowserTracker browserTracker = this.tracker;
            if (browserTracker == null) break block2;
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView = null;
            }
            int n = WebViews.INSTANCE.getPageIndex(webView);
            WebView webView2 = this.webView;
            if (webView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView2 = null;
            }
            browserTracker.logPagePause(n, WebViews.INSTANCE.getScrollDepth(webView2));
        }
    }

    protected void onResume() {
        block0: {
            super.onResume();
            BrowserTracker browserTracker = this.tracker;
            if (browserTracker == null) break block0;
            browserTracker.logPageResume();
        }
    }

    public void onBackPressed() {
        block6: {
            block5: {
                WebView webView = this.webView;
                if (webView == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                    webView = null;
                }
                if (!webView.canGoBack()) break block5;
                WebView webView2 = this.webView;
                if (webView2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                    webView2 = null;
                }
                webView2.goBack();
                View view = this.toolbarClose;
                if (view == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"toolbarClose");
                    view = null;
                }
                view.setVisibility(0);
                BrowserMediaHeader browserMediaHeader = this.mediaHeader;
                boolean bl = browserMediaHeader != null ? !browserMediaHeader.getFloating() : false;
                if (!bl) break block6;
                break block6;
            }
            super.onBackPressed();
            BrowserTracker browserTracker = this.tracker;
            if (browserTracker == null) break block6;
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView = null;
            }
            int n = WebViews.INSTANCE.getPageIndex(webView);
            WebView webView3 = this.webView;
            if (webView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView3 = null;
            }
            browserTracker.logPageClose("go_back", n, WebViews.INSTANCE.getScrollDepth(webView3));
        }
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onDestroy() {
        super.onDestroy();
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.loadUrl("about:blank");
        WebView webView2 = this.webView;
        if (webView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView2 = null;
        }
        webView2.destroy();
    }

    private static final void setupActionBar$lambda$1(BrowserActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onBackPressed();
    }

    private static final void setupActionBar$lambda$2(BrowserActivity this$0, View it) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.finish();
            BrowserTracker browserTracker = this$0.tracker;
            if (browserTracker == null) break block2;
            WebView webView = this$0.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView = null;
            }
            int n = WebViews.INSTANCE.getPageIndex(webView);
            WebView webView2 = this$0.webView;
            if (webView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView2 = null;
            }
            browserTracker.logPageClose("close", n, WebViews.INSTANCE.getScrollDepth(webView2));
        }
    }

    private static final void setupActionBar$lambda$3(BrowserActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        View view = this$0.toolbarBack;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbarBack");
            view = null;
        }
        view.performClick();
    }

    private static final void setupActionBar$lambda$4(BrowserActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        View view = this$0.toolbarClose;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbarClose");
            view = null;
        }
        view.performClick();
    }

    private static final void setupActionBar$lambda$5(BrowserActivity this$0, AppBarLayout view, int offset) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Toolbar toolbar = this$0.toolbar;
        if (toolbar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbar");
            toolbar = null;
        }
        int translationY = toolbar.getHeight() - view.getHeight() - offset;
        View view2 = this$0.toolbarBack;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbarBack");
            view2 = null;
        }
        view2.setTranslationY((float)translationY);
        View view3 = this$0.toolbarClose;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolbarClose");
            view3 = null;
        }
        view3.setTranslationY((float)translationY);
    }

    private static final void setupFloating$lambda$7(BrowserActivity this$0, View it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            View view = this$0.floatingView;
            if (view == null) break block1;
            View it2 = view;
            boolean bl = false;
            ViewParent viewParent = it2.getParent();
            ViewGroup viewGroup = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
            if (viewGroup != null) {
                viewGroup.removeView(it2);
            }
        }
    }

    public static final /* synthetic */ void access$showLoading(BrowserActivity $this) {
        $this.showLoading();
    }

    public static final /* synthetic */ BrowserTracker access$getTracker$p(BrowserActivity $this) {
        return $this.tracker;
    }

    public static final /* synthetic */ WebView access$getWebView$p(BrowserActivity $this) {
        return $this.webView;
    }

    public static final /* synthetic */ ProgressBar access$getWebProgressBar$p(BrowserActivity $this) {
        return $this.webProgressBar;
    }

    public static final /* synthetic */ void access$hideLoading(BrowserActivity $this) {
        $this.hideLoading();
    }

    public static final /* synthetic */ BrowserMediaHeader access$getMediaHeader$p(BrowserActivity $this) {
        return $this.mediaHeader;
    }

    public static final /* synthetic */ void access$setNestedScrollingEnabled(BrowserActivity $this, boolean enabled) {
        $this.setNestedScrollingEnabled(enabled);
    }
}

