/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.browser;

import com.particles.android.ads.internal.domain.BrowserExtras;
import com.particles.android.ads.internal.domain.TrackingEvent;
import com.particles.android.ads.internal.tracking.EventTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\u0011J\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0015\u001a\u00020\u0011J\u0006\u0010\u0016\u001a\u00020\u0011J\u0006\u0010\u0017\u001a\u00020\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/particles/android/ads/browser/BrowserTracker;", "", "requestId", "", "adId", "adUnitId", "adClickedAt", "", "encryptedAdToken", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;)V", "pageIndex", "", "resumedSeq", "scrollDepth", "", "status", "logPageClose", "", "reason", "logPageLoaded", "logPagePause", "logPageResume", "logPageStart", "logTextLoaded", "Companion", "nova-sdk_release"})
public final class BrowserTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String requestId;
    @NotNull
    private final String adId;
    @NotNull
    private final String adUnitId;
    private final long adClickedAt;
    @NotNull
    private final String encryptedAdToken;
    private int status;
    private int resumedSeq;
    private int pageIndex;
    private float scrollDepth;
    public static final int STATUS_IDLE = 0;
    public static final int STATUS_STARTED = 1;
    public static final int STATUS_TEXT_LOADED = 2;
    public static final int STATUS_ALL_LOADED = 3;
    public static final int STATUS_CLOSED = 4;

    public BrowserTracker(@NotNull String requestId, @NotNull String adId, @NotNull String adUnitId, long adClickedAt, @NotNull String encryptedAdToken) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)adId, (String)"adId");
        Intrinsics.checkNotNullParameter((Object)adUnitId, (String)"adUnitId");
        Intrinsics.checkNotNullParameter((Object)encryptedAdToken, (String)"encryptedAdToken");
        this.requestId = requestId;
        this.adId = adId;
        this.adUnitId = adUnitId;
        this.adClickedAt = adClickedAt;
        this.encryptedAdToken = encryptedAdToken;
    }

    public final void logPageStart() {
        if (this.status >= 1) {
            return;
        }
        this.status = 1;
        long duration = System.currentTimeMillis() - this.adClickedAt;
        EventTracker.INSTANCE.fire(new TrackingEvent(0L, "nova_landing_page_start", null, null, 0L, null, null, null, this.adUnitId, this.encryptedAdToken, duration, null, null, null, null, null, null, 129277, null));
    }

    public final void logTextLoaded() {
        if (this.status >= 2) {
            return;
        }
        this.status = 2;
        long duration = System.currentTimeMillis() - this.adClickedAt;
        EventTracker.INSTANCE.fire(new TrackingEvent(0L, "nova_landing_page_text_load", null, null, 0L, null, null, null, this.adUnitId, this.encryptedAdToken, duration, null, null, null, null, null, null, 129277, null));
    }

    public final void logPageLoaded() {
        if (this.status >= 3) {
            return;
        }
        if (this.status < 2) {
            this.logTextLoaded();
        }
        this.status = 3;
        long duration = System.currentTimeMillis() - this.adClickedAt;
        EventTracker.INSTANCE.fire(new TrackingEvent(0L, "nova_landing_page_all_load", null, null, 0L, null, null, null, this.adUnitId, this.encryptedAdToken, duration, null, null, null, null, null, null, 129277, null));
    }

    public final void logPageClose(@NotNull String reason, int pageIndex, float scrollDepth) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (this.status >= 4) {
            return;
        }
        long duration = System.currentTimeMillis() - this.adClickedAt;
        EventTracker.INSTANCE.fire(new TrackingEvent(0L, "nova_landing_page_close", null, reason, 0L, null, null, null, this.adUnitId, this.encryptedAdToken, duration, null, null, null, null, new BrowserExtras(0, this.status, pageIndex, scrollDepth, 1, null), null, 96501, null));
        this.status = 4;
    }

    public final void logPagePause(int pageIndex, float scrollDepth) {
        if (this.status >= 4) {
            return;
        }
        this.pageIndex = pageIndex;
        this.scrollDepth = scrollDepth;
        ++this.resumedSeq;
        long duration = System.currentTimeMillis() - this.adClickedAt;
        EventTracker.INSTANCE.fire(new TrackingEvent(0L, "nova_landing_page_jump_out", null, null, 0L, null, null, null, this.adUnitId, this.encryptedAdToken, duration, null, null, null, null, new BrowserExtras(this.resumedSeq, this.status, pageIndex, scrollDepth), null, 96509, null));
    }

    public final void logPageResume() {
        if (this.status >= 4) {
            return;
        }
        if (this.resumedSeq <= 0) {
            return;
        }
        long duration = System.currentTimeMillis() - this.adClickedAt;
        EventTracker.INSTANCE.fire(new TrackingEvent(0L, "nova_landing_page_jump_in", null, null, 0L, null, null, null, this.adUnitId, this.encryptedAdToken, duration, null, null, null, null, new BrowserExtras(this.resumedSeq, this.status, this.pageIndex, this.scrollDepth), null, 96509, null));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/particles/android/ads/browser/BrowserTracker$Companion;", "", "()V", "STATUS_ALL_LOADED", "", "STATUS_CLOSED", "STATUS_IDLE", "STATUS_STARTED", "STATUS_TEXT_LOADED", "nova-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

