/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.browser;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.webkit.URLUtil;
import java.net.URLEncoder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/particles/android/ads/browser/DeeplinkHandler;", "", "redirectTo", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "handle", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "nova-sdk_release"})
public final class DeeplinkHandler {
    @NotNull
    private final Function1<String, Unit> redirectTo;

    public DeeplinkHandler(@NotNull Function1<? super String, Unit> redirectTo) {
        Intrinsics.checkNotNullParameter(redirectTo, (String)"redirectTo");
        this.redirectTo = redirectTo;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean handle(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (URLUtil.isNetworkUrl((String)uri.toString())) {
            return false;
        }
        try {
            Intent intent = Intent.parseUri((String)uri.toString(), (int)1);
            String fallbackUrl = intent.getStringExtra("browser_fallback_url");
            String marketReferrer = intent.getStringExtra("market_referrer");
            intent.removeExtra("browser_fallback_url");
            intent.removeExtra("market_referrer");
            try {
                context.startActivity(intent);
                return true;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                CharSequence charSequence = fallbackUrl;
                if (!(charSequence == null || charSequence.length() == 0) && URLUtil.isHttpsUrl((String)fallbackUrl)) {
                    this.redirectTo.invoke((Object)fallbackUrl);
                    return true;
                }
                String pkg = intent.getPackage();
                CharSequence charSequence2 = pkg;
                if (!(charSequence2 == null || charSequence2.length() == 0)) {
                    CharSequence charSequence3 = marketReferrer;
                    String playStoreUrl = charSequence3 == null || charSequence3.length() == 0 ? "https://play.google.com/store/apps/details?id=" + pkg : "https://play.google.com/store/apps/details?id=" + pkg + "&referrer=" + URLEncoder.encode(marketReferrer);
                    try {
                        void $this$handle_u24lambda_u240;
                        CharSequence charSequence4 = charSequence3 = new Intent("android.intent.action.VIEW");
                        Context context2 = context;
                        boolean bl = false;
                        $this$handle_u24lambda_u240.setData(Uri.parse((String)playStoreUrl));
                        $this$handle_u24lambda_u240.setPackage("com.android.vending");
                        context2.startActivity((Intent)charSequence3);
                    }
                    catch (ActivityNotFoundException e) {
                        this.redirectTo.invoke((Object)playStoreUrl);
                    }
                    return true;
                }
                return true;
            }
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

