/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import androidx.browser.customtabs.CustomTabsIntent;
import com.particles.android.ads.browser.BrowserActivity;
import com.particles.android.ads.browser.BrowserMediaHeader;
import com.particles.android.ads.internal.BaseAdImpl;
import com.particles.android.ads.internal.NativeAdImpl;
import com.particles.android.ads.internal.domain.AdSession;
import com.particles.android.ads.internal.domain.BrowserOption;
import com.particles.android.ads.internal.domain.Creative;
import com.particles.android.ads.internal.domain.Video;
import com.particles.android.ads.nativead.MediaView;
import com.particles.android.ads.nativead.NativeAd;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u000e\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/particles/android/ads/internal/AdClickHandler;", "", "view", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/view/View;Landroid/content/Context;)V", "handleClick", "", "ad", "Lcom/particles/android/ads/internal/BaseAdImpl;", "url", "", "openAdInBrowser", "openAdInWebView", "nova-sdk_release"})
public final class AdClickHandler {
    @NotNull
    private final View view;
    @NotNull
    private final Context context;

    public AdClickHandler(@NotNull View view, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.view = view;
        this.context = context;
    }

    public /* synthetic */ AdClickHandler(View view, Context context, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Context context2 = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
            context = context2;
        }
        this(view, context);
    }

    public final void handleClick(@NotNull BaseAdImpl ad, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)ad, (String)"ad");
        AdSession adSession = ad.getAdSession();
        Creative creative = adSession.getAd().getCreative();
        CharSequence charSequence = url;
        String clickThroughUrl = !(charSequence == null || charSequence.length() == 0) ? url : creative.getClickThroughUrl();
        if (((CharSequence)clickThroughUrl).length() == 0) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[creative.getBrowserOption().ordinal()]) {
            case 1: {
                this.openAdInWebView(this.context, clickThroughUrl, ad);
                break;
            }
            case 2: {
                try {
                    this.openAdInBrowser(this.context, clickThroughUrl);
                    break;
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public static /* synthetic */ void handleClick$default(AdClickHandler adClickHandler, BaseAdImpl baseAdImpl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        adClickHandler.handleClick(baseAdImpl, string);
    }

    private final void openAdInBrowser(Context context, String url) {
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder();
        CustomTabsIntent customTabsIntent = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabsIntent, (String)"build(...)");
        CustomTabsIntent customTabsIntent2 = customTabsIntent;
        if (!(context instanceof Activity)) {
            customTabsIntent2.intent.addFlags(0x10000000);
        }
        customTabsIntent2.launchUrl(context, Uri.parse((String)url));
    }

    private final void openAdInWebView(Context context, String url, BaseAdImpl ad) {
        Intent intent = new Intent(context, BrowserActivity.class);
        intent.putExtra("url", url);
        intent.putExtra("request_id", ad.getRequestId());
        intent.putExtra("ad_id", ad.getAdId());
        intent.putExtra("ad_unit_id", ad.getAdUnitId());
        intent.putExtra("ad_clicked_at", ad.getAdSession().getAdClickedAt());
        intent.putExtra("ad_token", ad.getAdSession().getAd().getEncryptedAdToken());
        if (ad instanceof NativeAdImpl && this.view instanceof MediaView && ((NativeAdImpl)ad).getCreativeType() == NativeAd.CreativeType.VIDEO) {
            Video video = ((NativeAdImpl)ad).getCreative().getVideo();
            boolean bl = video != null ? video.isContinuePlay() : false;
            if (bl) {
                BrowserMediaHeader.Companion.putAdToIntent((NativeAdImpl)ad, intent);
            }
        }
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BrowserOption.values().length];
            try {
                nArray[BrowserOption.IN_APP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrowserOption.BROWSER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

