/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal;

import android.view.View;
import com.particles.android.ads.BaseAd;
import com.particles.android.ads.internal.AdClickHandler;
import com.particles.android.ads.internal.AdListener;
import com.particles.android.ads.internal.domain.AdSession;
import com.particles.android.ads.internal.domain.AdViewability;
import com.particles.android.ads.internal.tracking.EventTracker;
import com.particles.android.ads.internal.tracking.Tracker;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00062\b\u0010&\u001a\u0004\u0018\u00010\u0017H\u0016J&\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u0006J\u0012\u0010,\u001a\u00020$2\b\u0010-\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010.\u001a\u00020$2\b\u0010-\u001a\u0004\u0018\u00010\u0006J\u000e\u0010/\u001a\u00020$2\u0006\u0010(\u001a\u00020)J\u0006\u00100\u001a\u00020$J\u0016\u00101\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u00102\u001a\u000203J \u00104\u001a\u00020$2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0018\u000105H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u001f\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\b\u00a8\u00066"}, d2={"Lcom/particles/android/ads/internal/BaseAdImpl;", "Lcom/particles/android/ads/BaseAd;", "adSession", "Lcom/particles/android/ads/internal/domain/AdSession;", "(Lcom/particles/android/ads/internal/domain/AdSession;)V", "adId", "", "getAdId", "()Ljava/lang/String;", "adListener", "Lcom/particles/android/ads/internal/AdListener;", "getAdListener$nova_sdk_release", "()Lcom/particles/android/ads/internal/AdListener;", "setAdListener$nova_sdk_release", "(Lcom/particles/android/ads/internal/AdListener;)V", "getAdSession", "()Lcom/particles/android/ads/internal/domain/AdSession;", "adSetId", "getAdSetId", "adUnitId", "getAdUnitId", "extras", "", "", "getExtras", "()Ljava/util/Map;", "isAvailable", "", "()Z", "price", "", "getPrice", "()D", "requestId", "getRequestId", "addExtra", "", "key", "value", "onAdClicked", "view", "Landroid/view/View;", "clickAreaName", "url", "onAdDismissed", "reason", "onAdHidden", "onAdImpressed", "onAdUnhidden", "onAdViewableImpressed", "adViewability", "Lcom/particles/android/ads/internal/domain/AdViewability;", "setExtras", "", "nova-sdk_release"})
@SourceDebugExtension(value={"SMAP\nBaseAdImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAdImpl.kt\ncom/particles/android/ads/internal/BaseAdImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public class BaseAdImpl
implements BaseAd {
    @NotNull
    private final AdSession adSession;
    @NotNull
    private final Map<String, Object> extras;
    @Nullable
    private AdListener adListener;

    public BaseAdImpl(@NotNull AdSession adSession) {
        Intrinsics.checkNotNullParameter((Object)adSession, (String)"adSession");
        this.adSession = adSession;
        this.extras = new LinkedHashMap();
    }

    @NotNull
    public final AdSession getAdSession() {
        return this.adSession;
    }

    @NotNull
    public final Map<String, Object> getExtras() {
        return this.extras;
    }

    @Override
    @NotNull
    public String getAdId() {
        return this.adSession.getAd().getAdId();
    }

    @Override
    @NotNull
    public String getAdSetId() {
        return this.adSession.getAd().getAdSetId();
    }

    @Override
    @NotNull
    public String getAdUnitId() {
        return this.adSession.getAdUnitId();
    }

    @Override
    @NotNull
    public String getRequestId() {
        return this.adSession.getId();
    }

    @Override
    public boolean isAvailable() {
        long it = System.currentTimeMillis();
        boolean bl = false;
        return this.adSession.getAd().getStartTimeMillis() <= it && it < this.adSession.getAd().getExpireTimeMillis();
    }

    @Override
    public double getPrice() {
        return this.adSession.getAd().getPrice();
    }

    @Override
    public void setExtras(@Nullable Map<String, ? extends Object> extras) {
        block0: {
            this.extras.clear();
            Map<String, ? extends Object> map2 = extras;
            if (map2 == null) break block0;
            Map<String, ? extends Object> it = map2;
            boolean bl = false;
            this.extras.putAll(it);
        }
    }

    @Override
    public void addExtra(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.extras.put(key, value);
    }

    @Nullable
    public final AdListener getAdListener$nova_sdk_release() {
        return this.adListener;
    }

    public final void setAdListener$nova_sdk_release(@Nullable AdListener adListener) {
        this.adListener = adListener;
    }

    public final void onAdImpressed(@NotNull View view) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            if (this.adSession.getAdImpressedAt() > 0L) {
                return;
            }
            this.adSession.onAdImpressed(this.extras);
            List<String> urls = this.adSession.getAd().getCreative().getImpressionTrackingUrls();
            Tracker.fire$default((Tracker)EventTracker.INSTANCE, urls, null, 2, null);
            AdListener adListener = this.adListener;
            if (adListener == null) break block1;
            adListener.onAdImpressed();
        }
    }

    public final void onAdViewableImpressed(@NotNull View view, @NotNull AdViewability adViewability) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)adViewability, (String)"adViewability");
        if (this.adSession.getAdViewableImpressedAt() > 0L) {
            return;
        }
        this.adSession.onAdViewableImpressed(adViewability, this.extras);
    }

    public final void onAdClicked(@NotNull View view, @Nullable String clickAreaName, @Nullable String url) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            this.adSession.onAdClicked(clickAreaName, this.extras);
            new AdClickHandler(view, null, 2, null).handleClick(this, url);
            List<String> urls = this.adSession.getAd().getCreative().getClickTrackingUrls();
            Tracker.fire$default((Tracker)EventTracker.INSTANCE, urls, null, 2, null);
            AdListener adListener = this.adListener;
            if (adListener == null) break block0;
            adListener.onAdClicked();
        }
    }

    public static /* synthetic */ void onAdClicked$default(BaseAdImpl baseAdImpl, View view, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: onAdClicked");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        baseAdImpl.onAdClicked(view, string, string2);
    }

    public final void onAdHidden(@Nullable String reason) {
        if (!this.adSession.isAdHidden()) {
            this.adSession.onAdHidden(reason, this.extras);
        }
    }

    public final void onAdUnhidden() {
        if (this.adSession.isAdHidden()) {
            this.adSession.onAdUnhidden(this.extras);
        }
    }

    public void onAdDismissed(@Nullable String reason) {
        String type = "dismiss_ad";
        if (this.adSession.adEventTime(type) > 0L) {
            return;
        }
        this.adSession.onAdDismissed(reason, this.extras);
    }
}

