/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.data.cache;

import android.content.Context;
import com.particles.android.ads.internal.data.cache.AdCache;
import com.particles.android.ads.internal.data.entity.AdEntity;
import com.particles.android.ads.internal.data.mapper.AdEntityDataMapper;
import com.particles.android.ads.internal.data.mapper.AdEntityJsonMapper;
import com.particles.android.ads.internal.domain.Ad;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001b\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0014\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u001e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/particles/android/ads/internal/data/cache/AdCacheImpl;", "Lcom/particles/android/ads/internal/data/cache/AdCache;", "context", "Landroid/content/Context;", "name", "", "(Landroid/content/Context;Ljava/lang/String;)V", "rootDir", "Ljava/io/File;", "(Ljava/io/File;)V", "deleteFileRecursive", "", "file", "getAds", "", "Lcom/particles/android/ads/internal/domain/Ad;", "adUnitId", "maxNumberOfAds", "", "getCacheAdFiles", "dir", "getCacheAdFiles$nova_sdk_release", "getCacheDir", "putAds", "ads", "removeAds", "nova-sdk_release"})
@SourceDebugExtension(value={"SMAP\nAdCacheImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdCacheImpl.kt\ncom/particles/android/ads/internal/data/cache/AdCacheImpl\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n26#2:83\n11383#3,9:84\n13309#3:93\n13310#3:95\n11392#3:96\n13309#3,2:107\n1#4:94\n1#4:102\n1549#5:97\n1620#5,3:98\n1855#5:101\n1856#5:103\n1864#5,3:104\n*S KotlinDebug\n*F\n+ 1 AdCacheImpl.kt\ncom/particles/android/ads/internal/data/cache/AdCacheImpl\n*L\n20#1:83\n21#1:84,9\n21#1:93\n21#1:95\n21#1:96\n75#1:107,2\n21#1:94\n23#1:97\n23#1:98,3\n30#1:101\n30#1:103\n57#1:104,3\n*E\n"})
public final class AdCacheImpl
implements AdCache {
    @NotNull
    private final File rootDir;

    public AdCacheImpl(@NotNull File rootDir) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        this.rootDir = rootDir;
    }

    public AdCacheImpl(@NotNull Context context, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(new File(context.getCacheDir(), name));
    }

    private final File getCacheDir(String adUnitId) {
        return new File(this.rootDir, adUnitId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getCacheAdFiles$nova_sdk_release(@NotNull File dir) {
        void $this$mapTo$iv$iv;
        int n;
        Iterable $this$mapNotNullTo$iv$iv;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        String[] stringArray2 = dir.list();
        if (stringArray2 == null) {
            boolean $i$f$emptyArray = false;
            stringArray = new String[]{};
        } else {
            stringArray = stringArray2;
        }
        String[] $this$mapNotNull$iv = stringArray;
        boolean $i$f$mapNotNull = false;
        String[] stringArray3 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n2 = ((void)$this$forEach$iv$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            Integer it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[n];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (StringsKt.toIntOrNull((String)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File(dir, String.valueOf((int)it)));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<Ad> getAds(@NotNull String adUnitId, int maxNumberOfAds) {
        Intrinsics.checkNotNullParameter((Object)adUnitId, (String)"adUnitId");
        File dir = this.getCacheDir(adUnitId);
        List ads = new ArrayList();
        Iterable $this$forEach$iv = this.getCacheAdFiles$nova_sdk_release(dir);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            if (ads.size() >= maxNumberOfAds) continue;
            try {
                Ad ad;
                String text = FilesKt.readText$default((File)file, null, (int)1, null);
                AdEntity adEntity = AdEntityJsonMapper.INSTANCE.map(new JSONObject(text));
                Ad it = ad = AdEntityDataMapper.INSTANCE.map(adEntity);
                boolean bl2 = false;
                it.setLocalCachePath(file.getPath());
                Ad ad2 = ad;
                long now = System.currentTimeMillis();
                if (ad2.getExpireTimeMillis() < now) {
                    file.delete();
                    continue;
                }
                if (ad2.getStartTimeMillis() >= now) continue;
                ads.add(ad2);
                file.delete();
            }
            catch (Exception e) {
                file.delete();
            }
        }
        return ads;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAds(@NotNull String adUnitId, @NotNull List<Ad> ads) {
        Intrinsics.checkNotNullParameter((Object)adUnitId, (String)"adUnitId");
        Intrinsics.checkNotNullParameter(ads, (String)"ads");
        File dir = this.getCacheDir(adUnitId);
        this.deleteFileRecursive(dir);
        dir.mkdirs();
        Iterable $this$forEachIndexed$iv = ads;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Ad ad = (Ad)item$iv;
            int index = n;
            boolean bl = false;
            try {
                void ad2;
                File file;
                File it = file = new File(dir, String.valueOf(index));
                boolean bl2 = false;
                ad2.setLocalCachePath(it.getPath());
                FilesKt.writeText$default((File)file, (String)ad2.getRaw(), null, (int)2, null);
            }
            catch (Exception exception) {
            }
        }
    }

    @Override
    public void removeAds(@NotNull String adUnitId) {
        Intrinsics.checkNotNullParameter((Object)adUnitId, (String)"adUnitId");
        File dir = this.getCacheDir(adUnitId);
        this.deleteFileRecursive(dir);
    }

    private final void deleteFileRecursive(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    this.deleteFileRecursive(it);
                }
            }
        }
        file.delete();
    }
}

