/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.loader;

import android.content.Context;
import androidx.annotation.RequiresPermission;
import com.particles.android.ads.AdError;
import com.particles.android.ads.AdLoadListener;
import com.particles.android.ads.AdLoader;
import com.particles.android.ads.AdRequest;
import com.particles.android.ads.appopen.AppOpenAd;
import com.particles.android.ads.internal.AdErrorPool;
import com.particles.android.ads.internal.AppOpenAdImpl;
import com.particles.android.ads.internal.data.cache.AdCacheImpl;
import com.particles.android.ads.internal.domain.Ad;
import com.particles.android.ads.internal.domain.AdSession;
import com.particles.android.ads.internal.loader.GetAdsTask2;
import com.particles.android.ads.internal.util.Callback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014H\u0002J,\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014H\u0002J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0002J\u0016\u0010\u001f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/particles/android/ads/internal/loader/AppOpenAdLoader;", "Lcom/particles/android/ads/AdLoader;", "context", "Landroid/content/Context;", "adUnitId", "", "listener", "Lcom/particles/android/ads/AdLoadListener;", "Lcom/particles/android/ads/appopen/AppOpenAd;", "(Landroid/content/Context;Ljava/lang/String;Lcom/particles/android/ads/AdLoadListener;)V", "cache", "Lcom/particles/android/ads/internal/data/cache/AdCacheImpl;", "loadAds", "", "adRequest", "Lcom/particles/android/ads/AdRequest;", "maxNumberOfAds", "", "loadAdsFromCache", "callback", "Lcom/particles/android/ads/internal/util/Callback;", "", "Lcom/particles/android/ads/internal/domain/Ad;", "loadAdsFromNetwork", "loadAdsLegacy", "loadAdsOptimization", "notifyAdLoadFailed", "adError", "Lcom/particles/android/ads/AdError;", "notifyAdLoaded", "ads", "saveAdsToCache", "nova-sdk_release"})
public final class AppOpenAdLoader
implements AdLoader {
    @NotNull
    private final Context context;
    @NotNull
    private final String adUnitId;
    @NotNull
    private final AdLoadListener<AppOpenAd> listener;
    @NotNull
    private final AdCacheImpl cache;

    public AppOpenAdLoader(@NotNull Context context, @NotNull String adUnitId, @NotNull AdLoadListener<AppOpenAd> listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)adUnitId, (String)"adUnitId");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.context = context;
        this.adUnitId = adUnitId;
        this.listener = listener;
        this.cache = new AdCacheImpl(this.context, "nova-ads");
    }

    @Override
    public void loadAds(@NotNull AdRequest adRequest, int maxNumberOfAds) {
        Intrinsics.checkNotNullParameter((Object)adRequest, (String)"adRequest");
        this.loadAdsLegacy(adRequest, maxNumberOfAds);
    }

    private final void loadAdsOptimization(AdRequest adRequest, int maxNumberOfAds) {
        if (adRequest.getRequestOptions().getOnlyRetrieveFromCache()) {
            this.loadAdsFromCache(maxNumberOfAds, (Callback<List<Ad>>)new Callback<List<? extends Ad>>(this, adRequest){
                final /* synthetic */ AppOpenAdLoader this$0;
                final /* synthetic */ AdRequest $adRequest;
                {
                    this.this$0 = $receiver;
                    this.$adRequest = $adRequest;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onSuccess(@NotNull List<Ad> result) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter(result, (String)"result");
                    Iterable iterable = result;
                    AppOpenAdLoader appOpenAdLoader = this.this$0;
                    AdRequest adRequest = this.$adRequest;
                    boolean $i$f$map = false;
                    void var7_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Ad ad = (Ad)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new AppOpenAdImpl(new AdSession(AppOpenAdLoader.access$getAdUnitId$p(appOpenAdLoader), adRequest, (Ad)it)));
                    }
                    List ads = (List)destination$iv$iv;
                    AppOpenAdLoader.access$notifyAdLoaded(this.this$0, ads);
                }

                public void onFailure(@NotNull Throwable e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AdError adError = e instanceof AdError ? (AdError)e : AdErrorPool.GENERAL_LOAD_ERROR.toAdError(e);
                    AppOpenAdLoader.access$notifyAdLoadFailed(this.this$0, adError);
                }
            });
        } else {
            this.loadAdsFromNetwork(adRequest, maxNumberOfAds, (Callback<List<Ad>>)new Callback<List<? extends Ad>>(this, adRequest){
                final /* synthetic */ AppOpenAdLoader this$0;
                final /* synthetic */ AdRequest $adRequest;
                {
                    this.this$0 = $receiver;
                    this.$adRequest = $adRequest;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onSuccess(@NotNull List<Ad> result) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter(result, (String)"result");
                    AppOpenAdLoader.access$saveAdsToCache(this.this$0, result);
                    Iterable iterable = result;
                    AppOpenAdLoader appOpenAdLoader = this.this$0;
                    AdRequest adRequest = this.$adRequest;
                    boolean $i$f$map = false;
                    void var7_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Ad ad = (Ad)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new AppOpenAdImpl(new AdSession(AppOpenAdLoader.access$getAdUnitId$p(appOpenAdLoader), adRequest, (Ad)it)));
                    }
                    List ads = (List)destination$iv$iv;
                    AppOpenAdLoader.access$notifyAdLoaded(this.this$0, ads);
                }

                public void onFailure(@NotNull Throwable e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AdError adError = e instanceof AdError ? (AdError)e : AdErrorPool.GENERAL_LOAD_ERROR.toAdError(e);
                    AppOpenAdLoader.access$notifyAdLoadFailed(this.this$0, adError);
                }
            });
        }
    }

    private final void loadAdsLegacy(AdRequest adRequest, int maxNumberOfAds) {
        Function0 loadAdsFromNetworkToCache2 = (Function0)new Function0<Unit>(this, adRequest){
            final /* synthetic */ AppOpenAdLoader this$0;
            final /* synthetic */ AdRequest $adRequest;
            {
                this.this$0 = $receiver;
                this.$adRequest = $adRequest;
                super(0);
            }

            public final void invoke() {
                AppOpenAdLoader.access$loadAdsFromNetwork(this.this$0, this.$adRequest, 3, new Callback<List<? extends Ad>>(this.this$0){
                    final /* synthetic */ AppOpenAdLoader this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onSuccess(@NotNull List<Ad> result) {
                        Intrinsics.checkNotNullParameter(result, (String)"result");
                        AppOpenAdLoader.access$saveAdsToCache(this.this$0, result);
                    }

                    public void onFailure(@NotNull Throwable e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    }
                });
            }
        };
        this.loadAdsFromCache(maxNumberOfAds, (Callback<List<Ad>>)new Callback<List<? extends Ad>>(this, (Function0<Unit>)loadAdsFromNetworkToCache2, adRequest){
            final /* synthetic */ AppOpenAdLoader this$0;
            final /* synthetic */ Function0<Unit> $loadAdsFromNetworkToCache;
            final /* synthetic */ AdRequest $adRequest;
            {
                this.this$0 = $receiver;
                this.$loadAdsFromNetworkToCache = $loadAdsFromNetworkToCache;
                this.$adRequest = $adRequest;
            }

            /*
             * WARNING - void declaration
             */
            public void onSuccess(@NotNull List<Ad> result) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(result, (String)"result");
                Iterable iterable = result;
                AppOpenAdLoader appOpenAdLoader = this.this$0;
                AdRequest adRequest = this.$adRequest;
                boolean $i$f$map = false;
                void var7_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Ad ad = (Ad)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new AppOpenAdImpl(new AdSession(AppOpenAdLoader.access$getAdUnitId$p(appOpenAdLoader), adRequest, (Ad)it)));
                }
                List ads = (List)destination$iv$iv;
                AppOpenAdLoader.access$notifyAdLoaded(this.this$0, ads);
                this.$loadAdsFromNetworkToCache.invoke();
            }

            public void onFailure(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AdError adError = e instanceof AdError ? (AdError)e : AdErrorPool.GENERAL_LOAD_ERROR.toAdError(e);
                AppOpenAdLoader.access$notifyAdLoadFailed(this.this$0, adError);
                this.$loadAdsFromNetworkToCache.invoke();
            }
        });
    }

    private final void saveAdsToCache(List<Ad> ads) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ads, null){
            int label;
            final /* synthetic */ AppOpenAdLoader this$0;
            final /* synthetic */ List<Ad> $ads;
            {
                this.this$0 = $receiver;
                this.$ads = $ads;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AppOpenAdLoader.access$getCache$p(this.this$0).putAds(AppOpenAdLoader.access$getAdUnitId$p(this.this$0), this.$ads);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void loadAdsFromCache(int maxNumberOfAds, Callback<List<Ad>> callback2) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, maxNumberOfAds, callback2, null){
            int label;
            final /* synthetic */ AppOpenAdLoader this$0;
            final /* synthetic */ int $maxNumberOfAds;
            final /* synthetic */ Callback<List<Ad>> $callback;
            {
                this.this$0 = $receiver;
                this.$maxNumberOfAds = $maxNumberOfAds;
                this.$callback = $callback;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        List<Ad> ads = AppOpenAdLoader.access$getCache$p(this.this$0).getAds(AppOpenAdLoader.access$getAdUnitId$p(this.this$0), this.$maxNumberOfAds);
                        if (ads.isEmpty()) {
                            this.$callback.onFailure(AdErrorPool.GENERAL_LOAD_ERROR.toAdError());
                        } else {
                            this.$callback.onSuccess(ads);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void loadAdsFromNetwork(AdRequest adRequest, int maxNumberOfAds, Callback<List<Ad>> callback2) {
        String string = "APP_OPEN".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        GetAdsTask2 task = new GetAdsTask2(this.context, string, this.adUnitId, adRequest, maxNumberOfAds);
        task.getAds(callback2);
    }

    private final void notifyAdLoaded(List<? extends AppOpenAd> ads) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ads, null){
            int label;
            final /* synthetic */ AppOpenAdLoader this$0;
            final /* synthetic */ List<AppOpenAd> $ads;
            {
                this.this$0 = $receiver;
                this.$ads = $ads;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AppOpenAdLoader.access$getListener$p(this.this$0).onAdLoaded(this.$ads);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void notifyAdLoadFailed(AdError adError) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, adError, null){
            int label;
            final /* synthetic */ AppOpenAdLoader this$0;
            final /* synthetic */ AdError $adError;
            {
                this.this$0 = $receiver;
                this.$adError = $adError;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AppOpenAdLoader.access$getListener$p(this.this$0).onAdLoadFailed(this.$adError);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NotNull AdRequest adRequest) {
        AdLoader.DefaultImpls.loadAd(this, adRequest);
    }

    public static final /* synthetic */ void access$notifyAdLoaded(AppOpenAdLoader $this, List ads) {
        $this.notifyAdLoaded(ads);
    }

    public static final /* synthetic */ void access$notifyAdLoadFailed(AppOpenAdLoader $this, AdError adError) {
        $this.notifyAdLoadFailed(adError);
    }

    public static final /* synthetic */ String access$getAdUnitId$p(AppOpenAdLoader $this) {
        return $this.adUnitId;
    }

    public static final /* synthetic */ void access$saveAdsToCache(AppOpenAdLoader $this, List ads) {
        $this.saveAdsToCache(ads);
    }

    public static final /* synthetic */ void access$loadAdsFromNetwork(AppOpenAdLoader $this, AdRequest adRequest, int maxNumberOfAds, Callback callback2) {
        $this.loadAdsFromNetwork(adRequest, maxNumberOfAds, callback2);
    }

    public static final /* synthetic */ AdCacheImpl access$getCache$p(AppOpenAdLoader $this) {
        return $this.cache;
    }

    public static final /* synthetic */ AdLoadListener access$getListener$p(AppOpenAdLoader $this) {
        return $this.listener;
    }
}

