/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.loader;

import android.content.Context;
import androidx.annotation.RequiresPermission;
import com.particles.android.ads.AdError;
import com.particles.android.ads.AdLoadListener;
import com.particles.android.ads.AdLoader;
import com.particles.android.ads.AdRequest;
import com.particles.android.ads.internal.AdErrorPool;
import com.particles.android.ads.internal.NativeAdImpl;
import com.particles.android.ads.internal.domain.Ad;
import com.particles.android.ads.internal.domain.AdSession;
import com.particles.android.ads.internal.loader.GetAdsTask2;
import com.particles.android.ads.internal.util.Callback;
import com.particles.android.ads.nativead.NativeAd;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/particles/android/ads/internal/loader/NativeAdLoader;", "Lcom/particles/android/ads/AdLoader;", "context", "Landroid/content/Context;", "adUnitId", "", "listener", "Lcom/particles/android/ads/AdLoadListener;", "Lcom/particles/android/ads/nativead/NativeAd;", "(Landroid/content/Context;Ljava/lang/String;Lcom/particles/android/ads/AdLoadListener;)V", "loadAds", "", "adRequest", "Lcom/particles/android/ads/AdRequest;", "maxNumberOfAds", "", "nova-sdk_release"})
public final class NativeAdLoader
implements AdLoader {
    @NotNull
    private final Context context;
    @NotNull
    private final String adUnitId;
    @NotNull
    private final AdLoadListener<NativeAd> listener;

    public NativeAdLoader(@NotNull Context context, @NotNull String adUnitId, @NotNull AdLoadListener<NativeAd> listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)adUnitId, (String)"adUnitId");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.context = context;
        this.adUnitId = adUnitId;
        this.listener = listener;
    }

    @Override
    public void loadAds(@NotNull AdRequest adRequest, int maxNumberOfAds) {
        Intrinsics.checkNotNullParameter((Object)adRequest, (String)"adRequest");
        Callback<List<? extends Ad>> callback2 = new Callback<List<? extends Ad>>(this, adRequest){
            final /* synthetic */ NativeAdLoader this$0;
            final /* synthetic */ AdRequest $adRequest;
            {
                this.this$0 = $receiver;
                this.$adRequest = $adRequest;
            }

            /*
             * WARNING - void declaration
             */
            public void onSuccess(@NotNull List<Ad> result) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(result, (String)"result");
                Iterable iterable = result;
                NativeAdLoader nativeAdLoader = this.this$0;
                AdRequest adRequest = this.$adRequest;
                boolean $i$f$map = false;
                void var7_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Ad ad = (Ad)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new NativeAdImpl(new AdSession(NativeAdLoader.access$getAdUnitId$p(nativeAdLoader), adRequest, (Ad)it)));
                }
                List ads = (List)destination$iv$iv;
                NativeAdLoader.access$getListener$p(this.this$0).onAdLoaded(ads);
            }

            public void onFailure(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AdError adError = e instanceof AdError ? (AdError)e : AdErrorPool.GENERAL_LOAD_ERROR.toAdError(e);
                NativeAdLoader.access$getListener$p(this.this$0).onAdLoadFailed(adError);
            }
        };
        String string = "NATIVE".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        GetAdsTask2 task = new GetAdsTask2(this.context, string, this.adUnitId, adRequest, maxNumberOfAds);
        task.getAds((Callback<List<Ad>>)callback2);
    }

    @Override
    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(@NotNull AdRequest adRequest) {
        AdLoader.DefaultImpls.loadAd(this, adRequest);
    }

    public static final /* synthetic */ AdLoadListener access$getListener$p(NativeAdLoader $this) {
        return $this.listener;
    }

    public static final /* synthetic */ String access$getAdUnitId$p(NativeAdLoader $this) {
        return $this.adUnitId;
    }
}

