/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.rendering;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.particles.android.ads.R;
import com.particles.android.ads.internal.BaseAdImpl;
import com.particles.android.ads.internal.NativeAdImpl;
import com.particles.android.ads.internal.domain.AdPlaybackState;
import com.particles.android.ads.internal.domain.AdSession;
import com.particles.android.ads.internal.domain.Creative;
import com.particles.android.ads.internal.domain.Video;
import com.particles.android.ads.internal.domain.VideoEvents;
import com.particles.android.ads.internal.rendering.MediaViewRenderer;
import com.particles.android.ads.internal.rendering.video.PlayerState;
import com.particles.android.ads.internal.rendering.video.VideoPlayerView;
import com.particles.android.ads.internal.util.Stopwatch;
import com.particles.android.ads.internal.util.VisibilityTracker;
import com.particles.android.ads.internal.util.viewability.OMMediaEvents;
import com.particles.android.ads.nativead.MediaListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002!\"B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\u001c\u0010\u001b\u001a\u00020\u00162\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/particles/android/ads/internal/rendering/MediaViewVideoRenderer;", "Lcom/particles/android/ads/internal/rendering/MediaViewRenderer;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "ad", "Lcom/particles/android/ads/internal/NativeAdImpl;", "autoplayHelper", "Lcom/particles/android/ads/internal/rendering/MediaViewVideoRenderer$AutoplayHelper;", "handler", "Landroid/os/Handler;", "videoView", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView;", "visibilityTracker", "Lcom/particles/android/ads/internal/util/VisibilityTracker;", "visiblePixels", "", "onAttachedToWindow", "", "onDetachedFromWindow", "onVisibilityChanged", "totalPixels", "savePlaybackState", "setNativeAd", "omMediaEvents", "Lcom/particles/android/ads/internal/util/viewability/OMMediaEvents;", "setUseController", "useController", "", "AutoplayHelper", "VideoEventListener", "nova-sdk_release"})
@SourceDebugExtension(value={"SMAP\nMediaViewVideoRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaViewVideoRenderer.kt\ncom/particles/android/ads/internal/rendering/MediaViewVideoRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
public final class MediaViewVideoRenderer
extends MediaViewRenderer {
    @NotNull
    private final Handler handler;
    @Nullable
    private final VideoPlayerView videoView;
    @Nullable
    private NativeAdImpl ad;
    @NotNull
    private final AutoplayHelper autoplayHelper;
    @NotNull
    private final VisibilityTracker visibilityTracker;
    private long visiblePixels;

    @JvmOverloads
    public MediaViewVideoRenderer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.handler = new Handler(Looper.getMainLooper());
        this.autoplayHelper = new AutoplayHelper();
        this.visibilityTracker = new VisibilityTracker((View)this, null, (Function2)new Function2<Long, Long, Unit>((Object)this){

            public final void invoke(long p0, long p1) {
                MediaViewVideoRenderer.access$onVisibilityChanged((MediaViewVideoRenderer)((Object)this.receiver), p0, p1);
            }
        }, 2, null);
        View view = LayoutInflater.from((Context)context).inflate(R.layout._nova_native_media_video, (ViewGroup)this);
        this.videoView = (VideoPlayerView)view.findViewById(R.id.video_player);
    }

    public /* synthetic */ MediaViewVideoRenderer(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final void setUseController(boolean useController) {
        block0: {
            VideoPlayerView videoPlayerView = this.videoView;
            if (videoPlayerView == null) break block0;
            videoPlayerView.setUseController(useController);
        }
    }

    @Override
    public void setNativeAd(@Nullable NativeAdImpl ad, @Nullable OMMediaEvents omMediaEvents) {
        if (!Intrinsics.areEqual((Object)this.ad, (Object)ad)) {
            CharSequence charSequence;
            float volume;
            String coverUrl;
            this.ad = ad;
            if (ad == null || ad.getCreative().getVideo() == null) {
                return;
            }
            Video video = ad.getCreative().getVideo();
            AdPlaybackState state = ad.getAdSession().getAdPlaybackState();
            boolean started = state.getPosition() >= 0L;
            String string = coverUrl = started ? null : video.getCoverUrl();
            float f = started ? state.getVolume() : (volume = video.isMutePlay() ? 0.0f : 1.0f);
            long l = started && state.getPlayWhenReady() ? 0L : (!started && video.isAutoPlay() ? ((charSequence = (CharSequence)coverUrl) == null || charSequence.length() == 0 ? 0L : 1000L) : -1L);
            long autoplayDelayMs = l;
            VideoPlayerView videoPlayerView = this.videoView;
            if (videoPlayerView != null) {
                videoPlayerView.setClickable(!video.isClickable());
            }
            VideoPlayerView videoPlayerView2 = this.videoView;
            if (videoPlayerView2 != null) {
                videoPlayerView2.setListener(new VideoEventListener(ad, new VideoEvents(ad.getAdSession(), omMediaEvents)));
            }
            VideoPlayerView videoPlayerView3 = this.videoView;
            if (videoPlayerView3 != null) {
                VideoPlayerView.setDataSource$default(videoPlayerView3, video.getVideoUrl(), coverUrl, state.getPosition(), volume, false, video.isLoopPlay(), 16, null);
            }
            this.autoplayHelper.playDelayed(autoplayDelayMs);
            if (ad.getCreative().getVideo().isContinuePlay()) {
                ad.getAdSession().getAdPlaybackState().setPlayWhenReady(autoplayDelayMs >= 0L);
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.visibilityTracker.startTracking();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Object object = this.ad;
        if (!(object != null && (object = ((NativeAdImpl)object).getCreative()) != null && (object = ((Creative)object).getVideo()) != null ? ((Video)object).isContinuePlay() : false)) {
            this.savePlaybackState();
        }
        this.visibilityTracker.stopTracking();
        VideoPlayerView videoPlayerView = this.videoView;
        if (videoPlayerView != null) {
            videoPlayerView.release();
        }
        this.ad = null;
    }

    private final void onVisibilityChanged(long visiblePixels, long totalPixels) {
        if (this.visiblePixels == 0L && visiblePixels > 0L) {
            AdSession adSession;
            NativeAdImpl nativeAdImpl;
            Object object = this.ad;
            boolean bl = object != null && (object = ((NativeAdImpl)object).getCreative()) != null && (object = ((Creative)object).getVideo()) != null ? ((Video)object).isContinuePlay() : false;
            if (bl && (nativeAdImpl = this.ad) != null && (adSession = nativeAdImpl.getAdSession()) != null) {
                AdSession adSession2;
                AdSession adSession3;
                AdSession it = adSession3 = adSession;
                boolean bl2 = false;
                AdSession adSession4 = adSession2 = it.getAdClickedAt() > 0L && it.getAdPlaybackState().getPosition() > 0L ? adSession3 : null;
                if (adSession2 != null) {
                    it = adSession2;
                    boolean bl3 = false;
                    VideoPlayerView videoPlayerView = this.videoView;
                    if (videoPlayerView != null) {
                        videoPlayerView.update(it.getAdPlaybackState().getPosition(), it.getAdPlaybackState().getVolume(), it.getAdPlaybackState().getPlayWhenReady());
                    }
                }
            }
        }
        this.visiblePixels = visiblePixels;
        long visiblePercent = totalPixels > 0L ? visiblePixels * (long)100 / totalPixels : 0L;
        this.autoplayHelper.setPlayable(visiblePercent > 95L);
    }

    private final void savePlaybackState() {
        block3: {
            AdPlaybackState output;
            Object object = this.videoView;
            if (object == null || (object = object.getPlayerState()) == null) break block3;
            VideoPlayerView it = object;
            boolean bl = false;
            Object object2 = this.ad;
            AdPlaybackState adPlaybackState = output = object2 != null && (object2 = ((BaseAdImpl)object2).getAdSession()) != null ? ((AdSession)object2).getAdPlaybackState() : null;
            if (adPlaybackState != null) {
                adPlaybackState.setPosition(((PlayerState)((Object)it)).getPosition());
            }
            AdPlaybackState adPlaybackState2 = output;
            if (adPlaybackState2 != null) {
                adPlaybackState2.setVolume(((PlayerState)((Object)it)).getVolume());
            }
            AdPlaybackState adPlaybackState3 = output;
            if (adPlaybackState3 != null) {
                adPlaybackState3.setPlayWhenReady(((PlayerState)((Object)it)).getPlayWhenReady() || this.autoplayHelper.needAutoPlay());
            }
        }
    }

    @JvmOverloads
    public MediaViewVideoRenderer(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public MediaViewVideoRenderer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$onVisibilityChanged(MediaViewVideoRenderer $this, long visiblePixels, long totalPixels) {
        $this.onVisibilityChanged(visiblePixels, totalPixels);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\bJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0004J\b\u0010\u000e\u001a\u00020\u000bH\u0002J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/particles/android/ads/internal/rendering/MediaViewVideoRenderer$AutoplayHelper;", "", "(Lcom/particles/android/ads/internal/rendering/MediaViewVideoRenderer;)V", "playDelayMills", "", "playRunnable", "Ljava/lang/Runnable;", "playable", "", "needAutoPlay", "onPlayableChanged", "", "playDelayed", "delayMills", "schedulePlay", "setPlayable", "nova-sdk_release"})
    private final class AutoplayHelper {
        private boolean playable;
        private long playDelayMills = -1L;
        @NotNull
        private final Runnable playRunnable = () -> AutoplayHelper.playRunnable$lambda$0(MediaViewVideoRenderer.this);

        public final void playDelayed(long delayMills) {
            MediaViewVideoRenderer.this.handler.removeCallbacks(this.playRunnable);
            this.playDelayMills = delayMills;
            if (this.playable) {
                this.schedulePlay();
            }
        }

        public final void setPlayable(boolean playable) {
            if (this.playable != playable) {
                this.playable = playable;
                this.onPlayableChanged();
            }
        }

        public final boolean needAutoPlay() {
            return this.playDelayMills >= 0L;
        }

        private final void onPlayableChanged() {
            MediaViewVideoRenderer.this.handler.removeCallbacks(this.playRunnable);
            boolean bl = this.playable;
            if (bl) {
                this.schedulePlay();
            } else if (!bl) {
                VideoPlayerView videoPlayerView = MediaViewVideoRenderer.this.videoView;
                boolean bl2 = videoPlayerView != null ? videoPlayerView.isPlaying() : false;
                if (bl2) {
                    MediaViewVideoRenderer.this.videoView.pause("auto");
                    this.playDelayMills = 0L;
                }
            }
        }

        private final void schedulePlay() {
            if (this.playDelayMills >= 0L) {
                MediaViewVideoRenderer.this.handler.postDelayed(this.playRunnable, this.playDelayMills);
                this.playDelayMills = -1L;
            }
        }

        private static final void playRunnable$lambda$0(MediaViewVideoRenderer this$0) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                VideoPlayerView videoPlayerView = this$0.videoView;
                if (videoPlayerView == null) break block0;
                videoPlayerView.resume("auto");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/particles/android/ads/internal/rendering/MediaViewVideoRenderer$VideoEventListener;", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView$Listener;", "ad", "Lcom/particles/android/ads/internal/NativeAdImpl;", "events", "Lcom/particles/android/ads/internal/domain/VideoEvents;", "(Lcom/particles/android/ads/internal/NativeAdImpl;Lcom/particles/android/ads/internal/domain/VideoEvents;)V", "duration", "", "isPlayingOrBuffering", "", "percent", "", "position", "stopwatch", "Lcom/particles/android/ads/internal/util/Stopwatch;", "onDurationUpdate", "", "onIsPlayingOrBufferingChanged", "onPause", "reason", "", "onPlay", "onProgressUpdate", "bufferedPosition", "onUserMute", "onUserUnmute", "nova-sdk_release"})
    private static final class VideoEventListener
    implements VideoPlayerView.Listener {
        @NotNull
        private final NativeAdImpl ad;
        @NotNull
        private final VideoEvents events;
        private long position;
        private long duration;
        private int percent;
        private boolean isPlayingOrBuffering;
        @NotNull
        private Stopwatch stopwatch;

        public VideoEventListener(@NotNull NativeAdImpl ad, @NotNull VideoEvents events) {
            Intrinsics.checkNotNullParameter((Object)ad, (String)"ad");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            this.ad = ad;
            this.events = events;
            this.percent = -1;
            this.stopwatch = new Stopwatch();
        }

        @Override
        public void onIsPlayingOrBufferingChanged(boolean isPlayingOrBuffering) {
            this.isPlayingOrBuffering = isPlayingOrBuffering;
            if (isPlayingOrBuffering) {
                this.stopwatch.start();
            } else {
                this.stopwatch.stop();
            }
        }

        @Override
        public void onPlay(@NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            VideoEvents.onVideoResume$default(this.events, reason, null, 2, null);
            Video video = this.ad.getCreative().getVideo();
            boolean bl = video != null ? video.isContinuePlay() : false;
            if (bl && Intrinsics.areEqual((Object)reason, (Object)"manual")) {
                this.ad.getAdSession().getAdPlaybackState().setPlayWhenReady(true);
            }
        }

        @Override
        public void onPause(@NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            VideoEvents.onVideoPause$default(this.events, reason, (int)this.duration, (int)this.position, null, 8, null);
            Video video = this.ad.getCreative().getVideo();
            boolean bl = video != null ? video.isContinuePlay() : false;
            if (bl && Intrinsics.areEqual((Object)reason, (Object)"manual")) {
                this.ad.getAdSession().getAdPlaybackState().setPlayWhenReady(false);
            }
        }

        @Override
        public void onUserMute() {
            VideoEvents.onVideoMute$default(this.events, null, 1, null);
            Video video = this.ad.getCreative().getVideo();
            boolean bl = video != null ? video.isContinuePlay() : false;
            if (bl) {
                this.ad.getAdSession().getAdPlaybackState().setVolume(0.0f);
            }
        }

        @Override
        public void onUserUnmute() {
            VideoEvents.onVideoUnmute$default(this.events, null, 1, null);
            Video video = this.ad.getCreative().getVideo();
            boolean bl = video != null ? video.isContinuePlay() : false;
            if (bl) {
                this.ad.getAdSession().getAdPlaybackState().setVolume(1.0f);
            }
        }

        @Override
        public void onDurationUpdate(long duration) {
            block0: {
                this.duration = duration;
                MediaListener mediaListener = this.ad.getMediaListener();
                if (mediaListener == null) break block0;
                mediaListener.onDurationUpdate(duration);
            }
        }

        @Override
        public void onProgressUpdate(long position, long bufferedPosition) {
            MediaListener mediaListener = this.ad.getMediaListener();
            if (mediaListener != null) {
                mediaListener.onProgressUpdate(position, bufferedPosition);
            }
            long duration = this.duration;
            if (position < 0L || duration <= 0L) {
                return;
            }
            if (this.position < 3000L && position >= 3000L) {
                VideoEvents.onVideoProgress$default(this.events, 3000L, null, 2, null);
            }
            this.position = position;
            Video video = this.ad.getCreative().getVideo();
            boolean bl = video != null ? video.isContinuePlay() : false;
            if (bl) {
                this.ad.getAdSession().getAdPlaybackState().setPosition(position);
            }
            int percent = (int)(position * (long)100 / duration);
            if (this.percent < 0 && percent >= 0) {
                VideoEvents.onVideoStart$default(this.events, (int)duration, (int)this.stopwatch.elapsedMills(), null, 4, null);
            } else if (this.percent < 25 && percent >= 25) {
                VideoEvents.onVideoFirstQuartile$default(this.events, null, 1, null);
            } else if (this.percent < 50 && percent >= 50) {
                VideoEvents.onVideoMidpoint$default(this.events, null, 1, null);
            } else if (this.percent < 75 && percent >= 75) {
                VideoEvents.onVideoThirdQuartile$default(this.events, null, 1, null);
            } else if (this.percent < 100 && percent >= 100) {
                this.stopwatch.reset();
                if (this.isPlayingOrBuffering) {
                    this.stopwatch.start();
                }
                VideoEvents.onVideoComplete$default(this.events, null, 1, null);
            }
            if (this.percent >= 100 && percent < 100) {
                AdPlaybackState adPlaybackState = this.ad.getAdSession().getAdPlaybackState();
                int n = adPlaybackState.getRepeatCount();
                adPlaybackState.setRepeatCount(n + 1);
            }
            this.percent = percent;
        }

        @Override
        public void onUserPlay() {
            VideoPlayerView.Listener.DefaultImpls.onUserPlay(this);
        }

        @Override
        public void onUserPause() {
            VideoPlayerView.Listener.DefaultImpls.onUserPause(this);
        }
    }
}

