/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.rendering.video;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.OptIn;
import androidx.media3.common.Player;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.particles.android.ads.R;
import java.util.Formatter;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0015\u0018\u0000 <2\u00020\u0001:\u0004<=>?B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010'\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010(\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010)\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+H\u0002J\u0006\u0010,\u001a\u00020\"J\u0006\u0010-\u001a\u00020\u001fJ\b\u0010.\u001a\u00020\"H\u0014J\b\u0010/\u001a\u00020\"H\u0014J\u0010\u00100\u001a\u00020\"2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u00101\u001a\u00020\"2\b\u00102\u001a\u0004\u0018\u00010\u001bJ\u0010\u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020\u001fH\u0002J\u0010\u00105\u001a\u00020\"2\b\u00102\u001a\u0004\u0018\u00010$J\b\u00106\u001a\u00020\u001fH\u0002J\u0006\u00104\u001a\u00020\"J\b\u00107\u001a\u00020\"H\u0002J\b\u00108\u001a\u00020\"H\u0002J\b\u00109\u001a\u00020\"H\u0003J\b\u0010:\u001a\u00020\"H\u0002J\b\u0010;\u001a\u00020\"H\u0002R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "componentListener", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController$ComponentListener;", "currentBufferedPosition", "", "currentPosition", "currentWindowOffset", "duration", "formatBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "formatter", "Ljava/util/Formatter;", "pauseButton", "Landroid/view/View;", "playButton", "player", "Landroidx/media3/common/Player;", "progressUpdateListener", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController$ProgressUpdateListener;", "remainingDurationView", "Landroid/widget/TextView;", "showRemainingDurationView", "", "updateProgressAction", "Lkotlin/reflect/KFunction0;", "", "userInteractionListener", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController$UserInteractionListener;", "volumeOffButton", "volumeOnButton", "dispatchPause", "dispatchPlay", "dispatchVolume", "volume", "", "hide", "isVisible", "onAttachedToWindow", "onDetachedFromWindow", "setPlayer", "setProgressUpdateListener", "listener", "setShowRemainingDurationView", "show", "setUserInteractionListener", "shouldShowPauseButton", "updateAll", "updatePlayPauseButton", "updateProgress", "updateTimeline", "updateVolumeButton", "Companion", "ComponentListener", "ProgressUpdateListener", "UserInteractionListener", "nova-sdk_release"})
public final class VideoPlayerController
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComponentListener componentListener;
    @Nullable
    private final View playButton;
    @Nullable
    private final View pauseButton;
    @Nullable
    private final View volumeOnButton;
    @Nullable
    private final View volumeOffButton;
    @Nullable
    private final TextView remainingDurationView;
    @NotNull
    private final StringBuilder formatBuilder;
    @NotNull
    private final Formatter formatter;
    private boolean showRemainingDurationView;
    @NotNull
    private final KFunction<Unit> updateProgressAction;
    @Nullable
    private Player player;
    @Nullable
    private ProgressUpdateListener progressUpdateListener;
    @Nullable
    private UserInteractionListener userInteractionListener;
    private long currentWindowOffset;
    private long currentPosition;
    private long currentBufferedPosition;
    private long duration;
    public static final long MAX_UPDATE_INTERVAL_MS = 1000L;
    public static final long DEFAULT_TIME_BAR_MIN_UPDATE_INTERVAL_MS = 200L;

    @JvmOverloads
    public VideoPlayerController(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.componentListener = new ComponentListener();
        this.formatBuilder = new StringBuilder();
        this.formatter = new Formatter(this.formatBuilder, Locale.getDefault());
        this.updateProgressAction = (KFunction)new Function0<Unit>((Object)this){

            public final void invoke() {
                VideoPlayerController.access$updateProgress((VideoPlayerController)((Object)this.receiver));
            }
        };
        this.currentPosition = -9223372036854775807L;
        this.currentBufferedPosition = -9223372036854775807L;
        this.duration = -9223372036854775807L;
        LayoutInflater.from((Context)context).inflate(R.layout._nova_native_media_video_controller, (ViewGroup)this);
        View view = this.playButton = this.findViewById(R.id.player_controller_play);
        if (view != null) {
            view.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        View view2 = this.pauseButton = this.findViewById(R.id.player_controller_pause);
        if (view2 != null) {
            view2.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        View view3 = this.volumeOnButton = this.findViewById(R.id.player_controller_volume_on);
        if (view3 != null) {
            view3.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        View view4 = this.volumeOffButton = this.findViewById(R.id.player_controller_volume_off);
        if (view4 != null) {
            view4.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        TextView textView = this.remainingDurationView = (TextView)this.findViewById(R.id.player_controller_remaining_duration);
        if (textView != null) {
            textView.setVisibility(this.showRemainingDurationView ? 0 : 8);
        }
    }

    public /* synthetic */ VideoPlayerController(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final void setPlayer(@Nullable Player player) {
        if (Intrinsics.areEqual((Object)this.player, (Object)player)) {
            return;
        }
        Player player2 = this.player;
        if (player2 != null) {
            player2.removeListener((Player.Listener)this.componentListener);
        }
        Player player3 = this.player = player;
        if (player3 != null) {
            player3.addListener((Player.Listener)this.componentListener);
        }
        this.updateAll();
    }

    public final void setProgressUpdateListener(@Nullable ProgressUpdateListener listener) {
        this.progressUpdateListener = listener;
    }

    public final void setUserInteractionListener(@Nullable UserInteractionListener listener) {
        this.userInteractionListener = listener;
    }

    public final void show() {
        if (!this.isVisible()) {
            this.setVisibility(0);
            this.updateAll();
        }
    }

    public final void hide() {
        if (this.isVisible()) {
            this.setVisibility(8);
            this.removeCallbacks(() -> VideoPlayerController.hide$lambda$0(this.updateProgressAction));
        }
    }

    public final boolean isVisible() {
        return this.getVisibility() == 0;
    }

    private final void updateAll() {
        this.updatePlayPauseButton();
        this.updateVolumeButton();
        this.updateTimeline();
    }

    private final void updatePlayPauseButton() {
        if (!this.isVisible() || !this.isAttachedToWindow()) {
            return;
        }
        boolean shouldShowPauseButton = this.shouldShowPauseButton();
        View view = this.playButton;
        if (view != null) {
            view.setVisibility(shouldShowPauseButton ? 8 : 0);
        }
        View view2 = this.pauseButton;
        if (view2 != null) {
            view2.setVisibility(shouldShowPauseButton ? 0 : 8);
        }
    }

    private final void updateVolumeButton() {
        if (!this.isVisible() || !this.isAttachedToWindow()) {
            return;
        }
        Player player = this.player;
        float volume = player != null ? player.getVolume() : 0.0f;
        View view = this.volumeOnButton;
        if (view != null) {
            view.setVisibility(volume > 0.0f ? 0 : 8);
        }
        View view2 = this.volumeOffButton;
        if (view2 != null) {
            view2.setVisibility(volume > 0.0f ? 8 : 0);
        }
    }

    private final void updateTimeline() {
        Player player = this.player;
        if (player == null) {
            return;
        }
        Player player2 = player;
        this.currentWindowOffset = 0L;
        long duration = player2.getContentDuration();
        boolean durationChanged = duration != this.duration;
        this.duration = duration;
        if (durationChanged) {
            ProgressUpdateListener progressUpdateListener = this.progressUpdateListener;
            if (progressUpdateListener != null) {
                progressUpdateListener.onDurationUpdate(duration);
            }
        }
        this.updateProgress();
    }

    @OptIn(markerClass={UnstableApi.class})
    private final void updateProgress() {
        int playbackState;
        if (!this.isVisible() || !this.isAttachedToWindow()) {
            return;
        }
        Player player = this.player;
        long position = 0L;
        long bufferedPosition = 0L;
        if (player != null) {
            position = this.currentWindowOffset + player.getContentPosition();
            bufferedPosition = this.currentWindowOffset + player.getContentBufferedPosition();
        }
        boolean positionChanged = position != this.currentPosition;
        boolean bufferedPositionChanged = bufferedPosition != this.currentBufferedPosition;
        this.currentPosition = position;
        this.currentBufferedPosition = bufferedPosition;
        if (this.remainingDurationView != null && positionChanged) {
            long remainingDuration = RangesKt.coerceAtLeast((long)(this.duration - position), (long)0L);
            this.remainingDurationView.setText((CharSequence)Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)remainingDuration));
            boolean shouldShow = position <= 5000L && this.duration > 0L;
            this.setShowRemainingDurationView(shouldShow);
        }
        if (positionChanged || bufferedPositionChanged) {
            ProgressUpdateListener progressUpdateListener = this.progressUpdateListener;
            if (progressUpdateListener != null) {
                progressUpdateListener.onProgressUpdate(position, bufferedPosition);
            }
        }
        this.removeCallbacks(() -> VideoPlayerController.updateProgress$lambda$1(this.updateProgressAction));
        Player player2 = player;
        int n = playbackState = player2 != null ? player2.getPlaybackState() : 1;
        if (player != null && player.isPlaying()) {
            long mediaTimeDelayMs = 1000L;
            long mediaTimeUntilNextFullSecondMs = (long)1000 - position % (long)1000;
            mediaTimeDelayMs = RangesKt.coerceAtMost((long)mediaTimeDelayMs, (long)mediaTimeUntilNextFullSecondMs);
            float playbackSpeed = player.getPlaybackParameters().speed;
            long delayMs = playbackSpeed > 0.0f ? (long)((float)mediaTimeDelayMs / playbackSpeed) : 1000L;
            delayMs = RangesKt.coerceIn((long)delayMs, (long)200L, (long)1000L);
            this.postDelayed(() -> VideoPlayerController.updateProgress$lambda$2(this.updateProgressAction), delayMs);
        } else if (playbackState != 4 && playbackState != 1) {
            this.postDelayed(() -> VideoPlayerController.updateProgress$lambda$3(this.updateProgressAction), 1000L);
        }
    }

    private final void setShowRemainingDurationView(boolean show) {
        if (this.showRemainingDurationView != show) {
            this.showRemainingDurationView = show;
            TextView textView = this.remainingDurationView;
            if (textView == null) {
                return;
            }
            TextView view = textView;
            view.animate().alpha(show ? 1.0f : 0.0f).setDuration(250L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(show, view){
                final /* synthetic */ boolean $show;
                final /* synthetic */ TextView $view;
                {
                    this.$show = $show;
                    this.$view = $view;
                }

                public void onAnimationStart(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    if (this.$show) {
                        this.$view.setVisibility(0);
                    }
                }

                public void onAnimationEnd(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    if (!this.$show) {
                        this.$view.setVisibility(8);
                    }
                }
            }).start();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldShowPauseButton() {
        if (this.player == null) return false;
        Player player = this.player;
        Intrinsics.checkNotNull((Object)player);
        if (player.getPlaybackState() == 4) return false;
        Player player2 = this.player;
        Intrinsics.checkNotNull((Object)player2);
        if (player2.getPlaybackState() == 1) return false;
        Player player3 = this.player;
        Intrinsics.checkNotNull((Object)player3);
        if (!player3.getPlayWhenReady()) return false;
        return true;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.updateAll();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(() -> VideoPlayerController.onDetachedFromWindow$lambda$4(this.updateProgressAction));
    }

    private final void dispatchPlay(Player player) {
        int state = player.getPlaybackState();
        switch (state) {
            case 1: {
                player.prepare();
                break;
            }
            case 4: {
                player.seekTo(player.getCurrentMediaItemIndex(), -9223372036854775807L);
            }
        }
        player.play();
    }

    private final void dispatchPause(Player player) {
        player.pause();
    }

    private final void dispatchVolume(Player player, float volume) {
        player.setVolume(volume);
    }

    @JvmOverloads
    public VideoPlayerController(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public VideoPlayerController(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void hide$lambda$0(KFunction $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        ((Function0)$tmp0).invoke();
    }

    private static final void updateProgress$lambda$1(KFunction $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        ((Function0)$tmp0).invoke();
    }

    private static final void updateProgress$lambda$2(KFunction $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        ((Function0)$tmp0).invoke();
    }

    private static final void updateProgress$lambda$3(KFunction $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        ((Function0)$tmp0).invoke();
    }

    private static final void onDetachedFromWindow$lambda$4(KFunction $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        ((Function0)$tmp0).invoke();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController$Companion;", "", "()V", "DEFAULT_TIME_BAR_MIN_UPDATE_INTERVAL_MS", "", "MAX_UPDATE_INTERVAL_MS", "nova-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController$ComponentListener;", "Landroidx/media3/common/Player$Listener;", "Landroid/view/View$OnClickListener;", "(Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController;)V", "onClick", "", "v", "Landroid/view/View;", "onEvents", "player", "Landroidx/media3/common/Player;", "events", "Landroidx/media3/common/Player$Events;", "nova-sdk_release"})
    private final class ComponentListener
    implements Player.Listener,
    View.OnClickListener {
        public void onEvents(@NotNull Player player, @NotNull Player.Events events) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            int[] nArray = new int[]{4, 5};
            if (events.containsAny(nArray)) {
                VideoPlayerController.this.updatePlayPauseButton();
            }
            nArray = new int[]{4, 5, 7};
            if (events.containsAny(nArray)) {
                VideoPlayerController.this.updateProgress();
            }
            nArray = new int[]{11, 0};
            if (events.containsAny(nArray)) {
                VideoPlayerController.this.updateTimeline();
            }
            nArray = new int[]{22};
            if (events.containsAny(nArray)) {
                VideoPlayerController.this.updateVolumeButton();
            }
        }

        public void onClick(@Nullable View v) {
            block3: {
                View view;
                Player player;
                block5: {
                    block4: {
                        block2: {
                            Player player2 = VideoPlayerController.this.player;
                            if (player2 == null) {
                                return;
                            }
                            player = player2;
                            view = v;
                            if (!Intrinsics.areEqual((Object)view, (Object)VideoPlayerController.this.playButton)) break block2;
                            VideoPlayerController.this.dispatchPlay(player);
                            UserInteractionListener userInteractionListener = VideoPlayerController.this.userInteractionListener;
                            if (userInteractionListener == null) break block3;
                            userInteractionListener.onUserPlay();
                            break block3;
                        }
                        if (!Intrinsics.areEqual((Object)view, (Object)VideoPlayerController.this.pauseButton)) break block4;
                        VideoPlayerController.this.dispatchPause(player);
                        UserInteractionListener userInteractionListener = VideoPlayerController.this.userInteractionListener;
                        if (userInteractionListener == null) break block3;
                        userInteractionListener.onUserPause();
                        break block3;
                    }
                    if (!Intrinsics.areEqual((Object)view, (Object)VideoPlayerController.this.volumeOnButton)) break block5;
                    VideoPlayerController.this.dispatchVolume(player, 0.0f);
                    UserInteractionListener userInteractionListener = VideoPlayerController.this.userInteractionListener;
                    if (userInteractionListener == null) break block3;
                    userInteractionListener.onUserMute();
                    break block3;
                }
                if (!Intrinsics.areEqual((Object)view, (Object)VideoPlayerController.this.volumeOffButton)) break block3;
                VideoPlayerController.this.dispatchVolume(player, 1.0f);
                UserInteractionListener userInteractionListener = VideoPlayerController.this.userInteractionListener;
                if (userInteractionListener != null) {
                    userInteractionListener.onUserUnmute();
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController$ProgressUpdateListener;", "", "onDurationUpdate", "", "duration", "", "onProgressUpdate", "position", "bufferedPosition", "nova-sdk_release"})
    public static interface ProgressUpdateListener {
        public void onDurationUpdate(long var1);

        public void onProgressUpdate(long var1, long var3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0003H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController$UserInteractionListener;", "", "onUserMute", "", "onUserPause", "onUserPlay", "onUserUnmute", "nova-sdk_release"})
    public static interface UserInteractionListener {
        public void onUserPlay();

        public void onUserPause();

        public void onUserMute();

        public void onUserUnmute();
    }
}

