/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.rendering.video;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.OptIn;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Player;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSink;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.datasource.cache.Cache;
import androidx.media3.datasource.cache.CacheDataSink;
import androidx.media3.datasource.cache.CacheDataSource;
import androidx.media3.datasource.cache.SimpleCache;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.source.DefaultMediaSourceFactory;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.ui.PlayerView;
import com.bumptech.glide.Glide;
import com.particles.android.ads.R;
import com.particles.android.ads.internal.rendering.video.NovaVideoCacheManager;
import com.particles.android.ads.internal.rendering.video.PlayerState;
import com.particles.android.ads.internal.rendering.video.VideoPlayerController;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\u0018\u0000 ?2\u00020\u0001:\u0003?@AB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0003J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\b\u0010 \u001a\u0004\u0018\u00010!J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\u0006\u0010%\u001a\u00020\u001aJ\u0012\u0010&\u001a\u00020\u001a2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\u000e\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u001eJ\u0006\u0010)\u001a\u00020#J\u000e\u0010*\u001a\u00020#2\u0006\u0010(\u001a\u00020\u001eJ\u0010\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\u001aH\u0016J\u0012\u0010-\u001a\u00020#2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002JD\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020\u001e2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u00020\u001a2\b\b\u0002\u00106\u001a\u00020\u001aH\u0007J\u000e\u00107\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u00108\u001a\u00020#2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u000e\u00109\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010:\u001a\u00020#H\u0002J\b\u0010;\u001a\u00020#H\u0002J$\u0010<\u001a\u00020#2\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u0002042\b\b\u0002\u0010=\u001a\u00020\u001aJ\b\u0010>\u001a\u00020#H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "bigPlayButton", "Landroid/view/View;", "bigPlayButtonContainer", "bufferingView", "componentListener", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView$ComponentListener;", "controller", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController;", "coverImageView", "Landroid/widget/ImageView;", "listener", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView$Listener;", "player", "Landroidx/media3/exoplayer/ExoPlayer;", "playerView", "Landroidx/media3/ui/PlayerView;", "useController", "", "createMediaSource", "Landroidx/media3/exoplayer/source/MediaSource;", "uri", "", "createPlayer", "getPlayerState", "Lcom/particles/android/ads/internal/rendering/video/PlayerState;", "hideBigPlayButton", "", "hideCoverImage", "isPlaying", "isValidContextForGlide", "pause", "reason", "release", "resume", "setClickable", "clickable", "setCoverImageUri", "setDataSource", "videoUrl", "coverUrl", "position", "", "volume", "", "autoplay", "looping", "setListener", "setPlayer", "setUseController", "showBigPlayButton", "showCoverImage", "update", "playWhenReady", "updateBuffering", "Companion", "ComponentListener", "Listener", "nova-sdk_release"})
public final class VideoPlayerView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComponentListener componentListener;
    @Nullable
    private final PlayerView playerView;
    @Nullable
    private final View bufferingView;
    @Nullable
    private final VideoPlayerController controller;
    @Nullable
    private final ImageView coverImageView;
    @Nullable
    private final View bigPlayButtonContainer;
    @Nullable
    private final View bigPlayButton;
    private boolean useController;
    @Nullable
    private ExoPlayer player;
    @Nullable
    private Listener listener;
    @NotNull
    public static final String REASON_USER_INTERACTION = "manual";
    @NotNull
    public static final String REASON_VISIBILITY_CHANGED = "auto";

    @JvmOverloads
    public VideoPlayerView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.componentListener = new ComponentListener();
        this.useController = true;
        LayoutInflater.from((Context)context).inflate(R.layout._nova_native_media_video_player_view, (ViewGroup)this);
        this.playerView = (PlayerView)this.findViewById(R.id.player_view);
        View view = this.bufferingView = this.findViewById(R.id.buffering);
        if (view != null) {
            view.setVisibility(8);
        }
        VideoPlayerController videoPlayerController = this.controller = (VideoPlayerController)this.findViewById(R.id.player_controller);
        if (videoPlayerController != null) {
            videoPlayerController.setProgressUpdateListener(this.componentListener);
        }
        VideoPlayerController videoPlayerController2 = this.controller;
        if (videoPlayerController2 != null) {
            videoPlayerController2.setUserInteractionListener(this.componentListener);
        }
        VideoPlayerController videoPlayerController3 = this.controller;
        if (videoPlayerController3 != null) {
            videoPlayerController3.hide();
        }
        this.coverImageView = (ImageView)this.findViewById(R.id.player_cover_image);
        View view2 = this.bigPlayButtonContainer = this.findViewById(R.id.player_big_play_button_container);
        if (view2 != null) {
            view2.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        View view3 = this.bigPlayButton = this.findViewById(R.id.player_big_play_button);
        if (view3 != null) {
            view3.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.setOnClickListener(this.componentListener);
    }

    public /* synthetic */ VideoPlayerView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public void setClickable(boolean clickable) {
        super.setClickable(clickable);
        View view = this.bigPlayButton;
        if (view != null) {
            view.setClickable(clickable);
        }
        View view2 = this.bigPlayButton;
        if (view2 != null) {
            view2.setDuplicateParentStateEnabled(!clickable);
        }
        View view3 = this.bigPlayButtonContainer;
        if (view3 != null) {
            view3.setClickable(!clickable);
        }
    }

    public final void setListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
    }

    public final void setUseController(boolean useController) {
        block1: {
            this.useController = useController;
            if (useController) break block1;
            VideoPlayerController videoPlayerController = this.controller;
            if (videoPlayerController != null) {
                videoPlayerController.hide();
            }
        }
    }

    @OptIn(markerClass={UnstableApi.class})
    public final void setDataSource(@NotNull String videoUrl, @Nullable String coverUrl, long position, float volume, boolean autoplay, boolean looping) {
        ExoPlayer exoPlayer;
        Intrinsics.checkNotNullParameter((Object)videoUrl, (String)"videoUrl");
        ExoPlayer exoPlayer2 = this.player;
        if (exoPlayer2 != null) {
            ExoPlayer exoPlayer3;
            ExoPlayer it = exoPlayer3 = exoPlayer2;
            boolean bl = false;
            it.stop();
            it.clearMediaItems();
            exoPlayer = exoPlayer3;
        } else {
            exoPlayer = this.createPlayer();
        }
        ExoPlayer player = exoPlayer;
        this.setPlayer(player);
        this.setCoverImageUri(coverUrl);
        if (coverUrl != null) {
            this.showCoverImage();
        } else {
            this.hideCoverImage();
        }
        player.setAudioAttributes(AudioAttributes.DEFAULT, volume > 0.0f);
        player.setMediaSource(this.createMediaSource(videoUrl));
        player.setVolume(volume);
        player.setRepeatMode(looping ? 1 : 0);
        player.prepare();
        if (position >= 0L) {
            player.seekTo(position);
        } else {
            VideoPlayerController videoPlayerController = this.controller;
            if (videoPlayerController != null) {
                videoPlayerController.hide();
            }
            this.showBigPlayButton();
        }
        if (autoplay) {
            player.play();
        }
    }

    public static /* synthetic */ void setDataSource$default(VideoPlayerView videoPlayerView, String string, String string2, long l, float f, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            l = -1L;
        }
        if ((n & 8) != 0) {
            f = 0.0f;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        videoPlayerView.setDataSource(string, string2, l, f, bl, bl2);
    }

    public final void update(long position, float volume, boolean playWhenReady) {
        if (position >= 0L) {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer != null) {
                exoPlayer.seekTo(position);
            }
            ExoPlayer exoPlayer2 = this.player;
            if (exoPlayer2 != null) {
                exoPlayer2.setVolume(volume);
            }
            ExoPlayer exoPlayer3 = this.player;
            if (exoPlayer3 != null) {
                exoPlayer3.setPlayWhenReady(playWhenReady);
            }
        }
    }

    public static /* synthetic */ void update$default(VideoPlayerView videoPlayerView, long l, float f, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            l = -1L;
        }
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        videoPlayerView.update(l, f, bl);
    }

    public final void resume(@NotNull String reason) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer != null) {
                exoPlayer.play();
            }
            Listener listener = this.listener;
            if (listener == null) break block1;
            listener.onPlay(reason);
        }
    }

    public final boolean isPlaying() {
        ExoPlayer exoPlayer = this.player;
        return exoPlayer != null ? exoPlayer.getPlayWhenReady() : false;
    }

    public final void pause(@NotNull String reason) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer != null) {
                exoPlayer.pause();
            }
            Listener listener = this.listener;
            if (listener == null) break block1;
            listener.onPause(reason);
        }
    }

    public final void release() {
        block0: {
            ExoPlayer player = this.player;
            this.setPlayer(null);
            ExoPlayer exoPlayer = player;
            if (exoPlayer == null) break block0;
            exoPlayer.release();
        }
    }

    @Nullable
    public final PlayerState getPlayerState() {
        PlayerState playerState;
        ImageView imageView = this.coverImageView;
        boolean bl = imageView != null ? imageView.getVisibility() == 0 : false;
        if (bl) {
            return null;
        }
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            ExoPlayer it = exoPlayer;
            boolean bl2 = false;
            playerState = new PlayerState(it.getCurrentPosition(), it.getVolume(), it.getPlayWhenReady());
        } else {
            playerState = null;
        }
        return playerState;
    }

    private final void setPlayer(ExoPlayer player) {
        block4: {
            if (Intrinsics.areEqual((Object)this.player, (Object)player)) {
                return;
            }
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer != null) {
                exoPlayer.removeListener((Player.Listener)this.componentListener);
            }
            this.player = player;
            PlayerView playerView = this.playerView;
            if (playerView != null) {
                playerView.setPlayer((Player)player);
            }
            VideoPlayerController videoPlayerController = this.controller;
            if (videoPlayerController != null) {
                videoPlayerController.setPlayer((Player)player);
            }
            this.updateBuffering();
            ExoPlayer exoPlayer2 = this.player;
            if (exoPlayer2 == null) break block4;
            exoPlayer2.addListener((Player.Listener)this.componentListener);
        }
    }

    private final ExoPlayer createPlayer() {
        ExoPlayer exoPlayer = new ExoPlayer.Builder(this.getContext()).build();
        Intrinsics.checkNotNullExpressionValue((Object)exoPlayer, (String)"build(...)");
        return exoPlayer;
    }

    @OptIn(markerClass={UnstableApi.class})
    private final MediaSource createMediaSource(String uri) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        SimpleCache cache = NovaVideoCacheManager.INSTANCE.getSimpleCache(context);
        DefaultMediaSourceFactory factory = new DefaultMediaSourceFactory((DataSource.Factory)new CacheDataSource.Factory().setCache((Cache)cache).setCacheWriteDataSinkFactory((DataSink.Factory)new CacheDataSink.Factory().setCache((Cache)cache)).setUpstreamDataSourceFactory((DataSource.Factory)new DefaultHttpDataSource.Factory()).setFlags(2));
        MediaSource mediaSource = factory.createMediaSource(MediaItem.fromUri((String)uri));
        Intrinsics.checkNotNullExpressionValue((Object)mediaSource, (String)"createMediaSource(...)");
        return mediaSource;
    }

    /*
     * Unable to fully structure code
     */
    private final void updateBuffering() {
        block2: {
            if (this.bufferingView == null) break block2;
            v0 = this.player;
            v1 = v0 != null ? v0.getPlaybackState() == 2 : false;
            if (!v1) ** GOTO lbl-1000
            v2 = this.player;
            v3 = v2 != null ? v2.getPlayWhenReady() : false;
            if (v3) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            showBufferingSpinner = v4;
            this.bufferingView.setVisibility(showBufferingSpinner != false ? 0 : 8);
        }
    }

    private final void showBigPlayButton() {
        View view = this.bigPlayButtonContainer;
        if (view != null) {
            view.setVisibility(0);
        }
    }

    private final void hideBigPlayButton() {
        View view = this.bigPlayButtonContainer;
        if (view != null) {
            view.setVisibility(8);
        }
    }

    private final void setCoverImageUri(String uri) {
        block1: {
            ImageView imageView = this.coverImageView;
            if (imageView == null) break block1;
            ImageView it = imageView;
            boolean bl = false;
            if (this.isValidContextForGlide(this.getContext())) {
                Glide.with((Context)this.getContext()).load(uri).into(it);
            }
        }
    }

    private final void showCoverImage() {
        ImageView imageView = this.coverImageView;
        if (imageView != null) {
            imageView.setVisibility(0);
        }
    }

    private final void hideCoverImage() {
        ImageView imageView = this.coverImageView;
        if (imageView != null) {
            imageView.setVisibility(8);
        }
    }

    private final boolean isValidContextForGlide(Context context) {
        if (context == null) {
            return false;
        }
        return !(context instanceof Activity) || !((Activity)context).isDestroyed() && !((Activity)context).isFinishing();
    }

    @JvmOverloads
    public VideoPlayerView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public VideoPlayerView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView$Companion;", "", "()V", "REASON_USER_INTERACTION", "", "REASON_VISIBILITY_CHANGED", "nova-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\tH\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\rH\u0016J\b\u0010\u001f\u001a\u00020\rH\u0016J\b\u0010 \u001a\u00020\rH\u0016J\b\u0010!\u001a\u00020\rH\u0016J\b\u0010\"\u001a\u00020\rH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView$ComponentListener;", "Landroidx/media3/common/Player$Listener;", "Landroid/view/View$OnClickListener;", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController$ProgressUpdateListener;", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController$UserInteractionListener;", "(Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView;)V", "duration", "", "isFirstFrameRendered", "", "isPlayingOrBuffering", "playWhenReady", "onClick", "", "v", "Landroid/view/View;", "onDurationUpdate", "onPlayWhenReadyChanged", "reason", "", "onPlaybackStateChanged", "playbackState", "onPositionDiscontinuity", "oldPosition", "Landroidx/media3/common/Player$PositionInfo;", "newPosition", "onProgressUpdate", "position", "bufferedPosition", "onRenderedFirstFrame", "onUserMute", "onUserPause", "onUserPlay", "onUserUnmute", "updateIsPlayingOrBuffering", "nova-sdk_release"})
    private final class ComponentListener
    implements Player.Listener,
    View.OnClickListener,
    VideoPlayerController.ProgressUpdateListener,
    VideoPlayerController.UserInteractionListener {
        private long duration;
        private boolean isFirstFrameRendered;
        private boolean playWhenReady;
        private boolean isPlayingOrBuffering;

        public void onRenderedFirstFrame() {
            this.isFirstFrameRendered = true;
            if (this.playWhenReady) {
                VideoPlayerView.this.hideCoverImage();
            }
        }

        public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
            VideoPlayerView.this.updateBuffering();
            this.updateIsPlayingOrBuffering();
            this.playWhenReady = playWhenReady;
            if (playWhenReady) {
                if (VideoPlayerView.this.useController) {
                    VideoPlayerController videoPlayerController = VideoPlayerView.this.controller;
                    if (videoPlayerController != null) {
                        videoPlayerController.show();
                    }
                }
                VideoPlayerView.this.hideBigPlayButton();
                if (this.isFirstFrameRendered) {
                    VideoPlayerView.this.hideCoverImage();
                }
            }
        }

        public void onPlaybackStateChanged(int playbackState) {
            block2: {
                VideoPlayerView.this.updateBuffering();
                this.updateIsPlayingOrBuffering();
                if (playbackState != 4) break block2;
                VideoPlayerController videoPlayerController = VideoPlayerView.this.controller;
                if (videoPlayerController != null) {
                    videoPlayerController.hide();
                }
                VideoPlayerView.this.showBigPlayButton();
                Listener listener = VideoPlayerView.this.listener;
                if (listener != null) {
                    listener.onProgressUpdate(this.duration, this.duration);
                }
            }
        }

        private final void updateIsPlayingOrBuffering() {
            block1: {
                boolean isPlayingOrBuffering = this.isPlayingOrBuffering();
                if (this.isPlayingOrBuffering == isPlayingOrBuffering) break block1;
                this.isPlayingOrBuffering = isPlayingOrBuffering;
                Listener listener = VideoPlayerView.this.listener;
                if (listener != null) {
                    listener.onIsPlayingOrBufferingChanged(isPlayingOrBuffering);
                }
            }
        }

        private final boolean isPlayingOrBuffering() {
            ExoPlayer exoPlayer = VideoPlayerView.this.player;
            if (exoPlayer == null) {
                return false;
            }
            ExoPlayer player = exoPlayer;
            return player.getPlaybackState() != 4 && player.getPlaybackState() != 1 && player.getPlayWhenReady();
        }

        public void onPositionDiscontinuity(@NotNull Player.PositionInfo oldPosition, @NotNull Player.PositionInfo newPosition, int reason) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)oldPosition, (String)"oldPosition");
                Intrinsics.checkNotNullParameter((Object)newPosition, (String)"newPosition");
                if (reason != 0) break block1;
                Listener listener = VideoPlayerView.this.listener;
                if (listener != null) {
                    listener.onProgressUpdate(this.duration, this.duration);
                }
            }
        }

        public void onClick(@Nullable View v) {
            block8: {
                if (!Intrinsics.areEqual((Object)v, (Object)VideoPlayerView.this.bigPlayButton) && !Intrinsics.areEqual((Object)v, (Object)VideoPlayerView.this.bigPlayButtonContainer)) break block8;
                ExoPlayer exoPlayer = VideoPlayerView.this.player;
                if (exoPlayer == null) {
                    return;
                }
                ExoPlayer player = exoPlayer;
                switch (player.getPlaybackState()) {
                    case 1: {
                        player.prepare();
                        break;
                    }
                    case 4: {
                        player.seekTo(player.getCurrentMediaItemIndex(), -9223372036854775807L);
                        break;
                    }
                }
                player.play();
                if (VideoPlayerView.this.useController) {
                    VideoPlayerController videoPlayerController = VideoPlayerView.this.controller;
                    if (videoPlayerController != null) {
                        videoPlayerController.show();
                    }
                }
                VideoPlayerView.this.hideBigPlayButton();
                Listener listener = VideoPlayerView.this.listener;
                if (listener != null) {
                    listener.onUserPlay();
                }
            }
        }

        @Override
        public void onUserPlay() {
            block0: {
                Listener listener = VideoPlayerView.this.listener;
                if (listener == null) break block0;
                listener.onUserPlay();
            }
        }

        @Override
        public void onUserPause() {
            block0: {
                Listener listener = VideoPlayerView.this.listener;
                if (listener == null) break block0;
                listener.onUserPause();
            }
        }

        @Override
        public void onUserMute() {
            block1: {
                ExoPlayer exoPlayer = VideoPlayerView.this.player;
                if (exoPlayer != null) {
                    exoPlayer.setAudioAttributes(AudioAttributes.DEFAULT, false);
                }
                Listener listener = VideoPlayerView.this.listener;
                if (listener == null) break block1;
                listener.onUserMute();
            }
        }

        @Override
        public void onUserUnmute() {
            block1: {
                ExoPlayer exoPlayer = VideoPlayerView.this.player;
                if (exoPlayer != null) {
                    exoPlayer.setAudioAttributes(AudioAttributes.DEFAULT, true);
                }
                Listener listener = VideoPlayerView.this.listener;
                if (listener == null) break block1;
                listener.onUserUnmute();
            }
        }

        @Override
        public void onDurationUpdate(long duration) {
            block0: {
                this.duration = duration;
                Listener listener = VideoPlayerView.this.listener;
                if (listener == null) break block0;
                listener.onDurationUpdate(duration);
            }
        }

        @Override
        public void onProgressUpdate(long position, long bufferedPosition) {
            block0: {
                Listener listener = VideoPlayerView.this.listener;
                if (listener == null) break block0;
                listener.onProgressUpdate(position, bufferedPosition);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH&J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView$Listener;", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController$UserInteractionListener;", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController$ProgressUpdateListener;", "onIsPlayingOrBufferingChanged", "", "isPlayingOrBuffering", "", "onPause", "reason", "", "onPlay", "onUserPause", "onUserPlay", "nova-sdk_release"})
    public static interface Listener
    extends VideoPlayerController.UserInteractionListener,
    VideoPlayerController.ProgressUpdateListener {
        public void onIsPlayingOrBufferingChanged(boolean var1);

        public void onPlay(@NotNull String var1);

        public void onPause(@NotNull String var1);

        @Override
        public void onUserPlay();

        @Override
        public void onUserPause();

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void onUserPlay(@NotNull Listener $this) {
                $this.onPlay(VideoPlayerView.REASON_USER_INTERACTION);
            }

            public static void onUserPause(@NotNull Listener $this) {
                $this.onPause(VideoPlayerView.REASON_USER_INTERACTION);
            }
        }
    }
}

