/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.rendering.video;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.OptIn;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Player;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSink;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.datasource.cache.Cache;
import androidx.media3.datasource.cache.CacheDataSink;
import androidx.media3.datasource.cache.CacheDataSource;
import androidx.media3.datasource.cache.SimpleCache;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.source.DefaultMediaSourceFactory;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.ui.PlayerView;
import com.particles.android.ads.R;
import com.particles.android.ads.internal.rendering.video.NovaVideoCacheManager;
import com.particles.android.ads.internal.rendering.video.PlayerState;
import com.particles.android.ads.internal.rendering.video.VideoPlayerController;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\r\u0018\u0000 92\u00020\u0001:\u00039:;B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0003J\b\u0010#\u001a\u00020\u0015H\u0002J\b\u0010$\u001a\u0004\u0018\u00010%J\u0006\u0010&\u001a\u00020\u0019J\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\"J\u0006\u0010)\u001a\u00020\u001cJ\u000e\u0010*\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\"J8\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\"2\b\b\u0002\u0010-\u001a\u00020\f2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020\u00192\b\b\u0002\u00101\u001a\u00020\u0019H\u0007J\u000e\u00102\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u00103\u001a\u00020\u001c2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u00104\u001a\u00020\u001cH\u0002J\b\u00105\u001a\u00020\u001cH\u0002J\b\u00106\u001a\u00020\u001cH\u0002J\b\u00107\u001a\u00020\u001cH\u0002J\b\u00108\u001a\u00020\u001cH\u0002R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView2;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "componentListener", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView2$ComponentListener;", "currentBufferedPosition", "", "currentPosition", "duration", "listener", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView2$Listener;", "pauseButton", "Landroid/view/View;", "playButton", "player", "Landroidx/media3/exoplayer/ExoPlayer;", "playerView", "Landroidx/media3/ui/PlayerView;", "shouldShowPauseButton", "", "updateProgressAction", "Lkotlin/reflect/KFunction0;", "", "volumeOffButton", "volumeOnButton", "createMediaSource", "Landroidx/media3/exoplayer/source/MediaSource;", "uri", "", "createPlayer", "getPlayerState", "Lcom/particles/android/ads/internal/rendering/video/PlayerState;", "isPlaying", "pause", "reason", "release", "resume", "setDataSource", "videoUrl", "position", "volume", "", "autoplay", "looping", "setListener", "setPlayer", "updateAll", "updatePlayPause", "updateProgress", "updateTimeline", "updateVolumeButton", "Companion", "ComponentListener", "Listener", "nova-sdk_release"})
public final class VideoPlayerView2
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComponentListener componentListener;
    @Nullable
    private final PlayerView playerView;
    @Nullable
    private final View playButton;
    @Nullable
    private final View pauseButton;
    @Nullable
    private final View volumeOnButton;
    @Nullable
    private final View volumeOffButton;
    @Nullable
    private ExoPlayer player;
    @Nullable
    private Listener listener;
    private long currentPosition;
    private long currentBufferedPosition;
    private long duration;
    @NotNull
    private final KFunction<Unit> updateProgressAction;
    private boolean shouldShowPauseButton;
    @NotNull
    public static final String REASON_USER_INTERACTION = "manual";
    @NotNull
    public static final String REASON_VISIBILITY_CHANGED = "auto";

    @JvmOverloads
    public VideoPlayerView2(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.componentListener = new ComponentListener();
        LayoutInflater.from((Context)context).inflate(R.layout._nova_native_media_video_player_view2, (ViewGroup)this);
        this.playerView = (PlayerView)this.findViewById(R.id.player_view);
        this.playButton = this.findViewById(R.id.exo_play);
        this.pauseButton = this.findViewById(R.id.exo_pause);
        this.volumeOnButton = this.findViewById(R.id.exo_volume_on);
        this.volumeOffButton = this.findViewById(R.id.exo_volume_off);
        this.playButton.setOnClickListener((View.OnClickListener)this.componentListener);
        this.pauseButton.setOnClickListener((View.OnClickListener)this.componentListener);
        this.volumeOnButton.setOnClickListener((View.OnClickListener)this.componentListener);
        this.volumeOffButton.setOnClickListener((View.OnClickListener)this.componentListener);
        this.currentPosition = -9223372036854775807L;
        this.currentBufferedPosition = -9223372036854775807L;
        this.duration = -9223372036854775807L;
        this.updateProgressAction = (KFunction)new Function0<Unit>((Object)this){

            public final void invoke() {
                VideoPlayerView2.access$updateProgress((VideoPlayerView2)((Object)this.receiver));
            }
        };
    }

    public /* synthetic */ VideoPlayerView2(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final void setListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
    }

    @OptIn(markerClass={UnstableApi.class})
    public final void setDataSource(@NotNull String videoUrl, long position, float volume, boolean autoplay, boolean looping) {
        ExoPlayer exoPlayer;
        Intrinsics.checkNotNullParameter((Object)videoUrl, (String)"videoUrl");
        ExoPlayer exoPlayer2 = this.player;
        if (exoPlayer2 != null) {
            ExoPlayer exoPlayer3;
            ExoPlayer it = exoPlayer3 = exoPlayer2;
            boolean bl = false;
            it.stop();
            it.clearMediaItems();
            exoPlayer = exoPlayer3;
        } else {
            exoPlayer = this.createPlayer();
        }
        ExoPlayer player = exoPlayer;
        this.setPlayer(player);
        player.setMediaSource(this.createMediaSource(videoUrl));
        player.setVolume(volume);
        player.setRepeatMode(looping ? 1 : 0);
        player.prepare();
        if (position >= 0L) {
            player.seekTo(position);
        }
        if (autoplay) {
            player.play();
        }
    }

    public static /* synthetic */ void setDataSource$default(VideoPlayerView2 videoPlayerView2, String string, long l, float f, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            l = -1L;
        }
        if ((n & 4) != 0) {
            f = 0.0f;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        videoPlayerView2.setDataSource(string, l, f, bl, bl2);
    }

    public final void resume(@NotNull String reason) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer != null) {
                exoPlayer.play();
            }
            Listener listener = this.listener;
            if (listener == null) break block1;
            listener.onPlay(reason);
        }
    }

    public final boolean isPlaying() {
        ExoPlayer exoPlayer = this.player;
        return exoPlayer != null ? exoPlayer.getPlayWhenReady() : false;
    }

    public final void pause(@NotNull String reason) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer != null) {
                exoPlayer.pause();
            }
            Listener listener = this.listener;
            if (listener == null) break block1;
            listener.onPause(reason);
        }
    }

    public final void release() {
        block0: {
            ExoPlayer player = this.player;
            this.setPlayer(null);
            ExoPlayer exoPlayer = player;
            if (exoPlayer == null) break block0;
            exoPlayer.release();
        }
    }

    @Nullable
    public final PlayerState getPlayerState() {
        PlayerState playerState;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            ExoPlayer it = exoPlayer;
            boolean bl = false;
            playerState = new PlayerState(it.getCurrentPosition(), it.getVolume(), it.getPlayWhenReady());
        } else {
            playerState = null;
        }
        return playerState;
    }

    private final void setPlayer(ExoPlayer player) {
        if (Intrinsics.areEqual((Object)this.player, (Object)player)) {
            return;
        }
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.removeListener((Player.Listener)this.componentListener);
        }
        this.player = player;
        PlayerView playerView = this.playerView;
        if (playerView != null) {
            playerView.setPlayer((Player)player);
        }
        ExoPlayer exoPlayer2 = this.player;
        if (exoPlayer2 != null) {
            exoPlayer2.addListener((Player.Listener)this.componentListener);
        }
        this.updateAll();
    }

    private final ExoPlayer createPlayer() {
        ExoPlayer exoPlayer = new ExoPlayer.Builder(this.getContext()).setAudioAttributes(AudioAttributes.DEFAULT, true).build();
        Intrinsics.checkNotNullExpressionValue((Object)exoPlayer, (String)"build(...)");
        return exoPlayer;
    }

    @OptIn(markerClass={UnstableApi.class})
    private final MediaSource createMediaSource(String uri) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        SimpleCache cache = NovaVideoCacheManager.INSTANCE.getSimpleCache(context);
        DefaultMediaSourceFactory factory = new DefaultMediaSourceFactory((DataSource.Factory)new CacheDataSource.Factory().setCache((Cache)cache).setCacheWriteDataSinkFactory((DataSink.Factory)new CacheDataSink.Factory().setCache((Cache)cache)).setUpstreamDataSourceFactory((DataSource.Factory)new DefaultHttpDataSource.Factory()).setFlags(2));
        MediaSource mediaSource = factory.createMediaSource(MediaItem.fromUri((String)uri));
        Intrinsics.checkNotNullExpressionValue((Object)mediaSource, (String)"createMediaSource(...)");
        return mediaSource;
    }

    private final void updateAll() {
        this.updatePlayPause();
        this.updateVolumeButton();
        this.updateTimeline();
    }

    private final void updateTimeline() {
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer == null) {
            return;
        }
        ExoPlayer player = exoPlayer;
        long duration = player.getContentDuration();
        boolean durationChanged = duration != this.duration;
        this.duration = duration;
        if (durationChanged) {
            Listener listener = this.listener;
            if (listener != null) {
                listener.onDurationUpdate(duration);
            }
        }
        this.updateProgress();
    }

    private final void updateProgress() {
        int playbackState;
        ExoPlayer player;
        if (!this.isAttachedToWindow()) {
            return;
        }
        ExoPlayer exoPlayer = player = this.player;
        long position = exoPlayer != null ? exoPlayer.getContentPosition() : 0L;
        ExoPlayer exoPlayer2 = player;
        long bufferedPosition = exoPlayer2 != null ? exoPlayer2.getContentBufferedPosition() : 0L;
        boolean positionChanged = position != this.currentPosition;
        boolean bufferedPositionChanged = bufferedPosition != this.currentBufferedPosition;
        this.currentPosition = position;
        this.currentBufferedPosition = bufferedPosition;
        if (positionChanged || bufferedPositionChanged) {
            Listener listener = this.listener;
            if (listener != null) {
                listener.onProgressUpdate(position, bufferedPosition);
            }
        }
        this.removeCallbacks(() -> VideoPlayerView2.updateProgress$lambda$2(this.updateProgressAction));
        ExoPlayer exoPlayer3 = player;
        int n = playbackState = exoPlayer3 != null ? exoPlayer3.getPlaybackState() : 1;
        if (player != null && player.isPlaying()) {
            long mediaTimeDelayMs = 1000L;
            long mediaTimeUntilNextFullSecondMs = (long)1000 - position % (long)1000;
            mediaTimeDelayMs = RangesKt.coerceAtMost((long)mediaTimeDelayMs, (long)mediaTimeUntilNextFullSecondMs);
            float playbackSpeed = player.getPlaybackParameters().speed;
            long delayMs = playbackSpeed > 0.0f ? (long)((float)mediaTimeDelayMs / playbackSpeed) : 1000L;
            delayMs = RangesKt.coerceIn((long)delayMs, (long)200L, (long)1000L);
            this.postDelayed(() -> VideoPlayerView2.updateProgress$lambda$3(this.updateProgressAction), delayMs);
        } else if (playbackState != 4 && playbackState != 1) {
            this.postDelayed(() -> VideoPlayerView2.updateProgress$lambda$4(this.updateProgressAction), 1000L);
        }
    }

    private final void updateVolumeButton() {
        if (!this.isAttachedToWindow()) {
            return;
        }
        ExoPlayer exoPlayer = this.player;
        float volume = exoPlayer != null ? exoPlayer.getVolume() : 0.0f;
        View view = this.volumeOnButton;
        if (view != null) {
            view.setVisibility(volume > 0.0f ? 0 : 8);
        }
        View view2 = this.volumeOffButton;
        if (view2 != null) {
            view2.setVisibility(volume > 0.0f ? 8 : 0);
        }
    }

    private final void updatePlayPause() {
        if (!this.isAttachedToWindow()) {
            return;
        }
        boolean shouldShowPauseButton = this.shouldShowPauseButton();
        if (this.shouldShowPauseButton != shouldShowPauseButton) {
            this.shouldShowPauseButton = shouldShowPauseButton;
            View view = this.playButton;
            if (view != null) {
                view.setVisibility(shouldShowPauseButton ? 8 : 0);
            }
            View view2 = this.pauseButton;
            if (view2 != null) {
                view2.setVisibility(shouldShowPauseButton ? 0 : 8);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldShowPauseButton() {
        if (this.player == null) return false;
        ExoPlayer exoPlayer = this.player;
        Intrinsics.checkNotNull((Object)exoPlayer);
        if (exoPlayer.getPlaybackState() == 4) return false;
        ExoPlayer exoPlayer2 = this.player;
        Intrinsics.checkNotNull((Object)exoPlayer2);
        if (exoPlayer2.getPlaybackState() == 1) return false;
        ExoPlayer exoPlayer3 = this.player;
        Intrinsics.checkNotNull((Object)exoPlayer3);
        if (!exoPlayer3.getPlayWhenReady()) return false;
        return true;
    }

    @JvmOverloads
    public VideoPlayerView2(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public VideoPlayerView2(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void updateProgress$lambda$2(KFunction $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        ((Function0)$tmp0).invoke();
    }

    private static final void updateProgress$lambda$3(KFunction $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        ((Function0)$tmp0).invoke();
    }

    private static final void updateProgress$lambda$4(KFunction $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        ((Function0)$tmp0).invoke();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView2$Companion;", "", "()V", "REASON_USER_INTERACTION", "", "REASON_VISIBILITY_CHANGED", "nova-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView2$ComponentListener;", "Landroidx/media3/common/Player$Listener;", "Landroid/view/View$OnClickListener;", "(Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView2;)V", "isPlayingOrBuffering", "", "onClick", "", "v", "Landroid/view/View;", "onEvents", "player", "Landroidx/media3/common/Player;", "events", "Landroidx/media3/common/Player$Events;", "onPlayWhenReadyChanged", "playWhenReady", "reason", "", "onPlaybackStateChanged", "playbackState", "onPositionDiscontinuity", "oldPosition", "Landroidx/media3/common/Player$PositionInfo;", "newPosition", "updateIsPlayingOrBuffering", "nova-sdk_release"})
    private final class ComponentListener
    implements Player.Listener,
    View.OnClickListener {
        private boolean isPlayingOrBuffering;

        public void onEvents(@NotNull Player player, @NotNull Player.Events events) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            int[] nArray = new int[]{4, 5};
            if (events.containsAny(nArray)) {
                VideoPlayerView2.this.updatePlayPause();
            }
            nArray = new int[]{4, 5, 7};
            if (events.containsAny(nArray)) {
                VideoPlayerView2.this.updateProgress();
            }
            nArray = new int[]{11, 0};
            if (events.containsAny(nArray)) {
                VideoPlayerView2.this.updateTimeline();
            }
            nArray = new int[]{22, 26};
            if (events.containsAny(nArray)) {
                VideoPlayerView2.this.updateVolumeButton();
            }
        }

        public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
            this.updateIsPlayingOrBuffering();
        }

        public void onPlaybackStateChanged(int playbackState) {
            block1: {
                this.updateIsPlayingOrBuffering();
                if (playbackState != 4) break block1;
                Listener listener = VideoPlayerView2.this.listener;
                if (listener != null) {
                    listener.onProgressUpdate(VideoPlayerView2.this.duration, VideoPlayerView2.this.duration);
                }
            }
        }

        private final void updateIsPlayingOrBuffering() {
            block1: {
                boolean isPlayingOrBuffering = this.isPlayingOrBuffering();
                if (this.isPlayingOrBuffering == isPlayingOrBuffering) break block1;
                this.isPlayingOrBuffering = isPlayingOrBuffering;
                Listener listener = VideoPlayerView2.this.listener;
                if (listener != null) {
                    listener.onIsPlayingOrBufferingChanged(isPlayingOrBuffering);
                }
            }
        }

        private final boolean isPlayingOrBuffering() {
            ExoPlayer exoPlayer = VideoPlayerView2.this.player;
            if (exoPlayer == null) {
                return false;
            }
            ExoPlayer player = exoPlayer;
            return player.getPlaybackState() != 4 && player.getPlaybackState() != 1 && player.getPlayWhenReady();
        }

        public void onPositionDiscontinuity(@NotNull Player.PositionInfo oldPosition, @NotNull Player.PositionInfo newPosition, int reason) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)oldPosition, (String)"oldPosition");
                Intrinsics.checkNotNullParameter((Object)newPosition, (String)"newPosition");
                if (reason != 0) break block1;
                Listener listener = VideoPlayerView2.this.listener;
                if (listener != null) {
                    listener.onProgressUpdate(VideoPlayerView2.this.duration, VideoPlayerView2.this.duration);
                }
            }
        }

        public void onClick(@Nullable View v) {
            block3: {
                View view;
                ExoPlayer player;
                block5: {
                    block4: {
                        block2: {
                            ExoPlayer exoPlayer = VideoPlayerView2.this.player;
                            if (exoPlayer == null) {
                                return;
                            }
                            player = exoPlayer;
                            view = v;
                            if (!Intrinsics.areEqual((Object)view, (Object)VideoPlayerView2.this.playButton)) break block2;
                            player.play();
                            Listener listener = VideoPlayerView2.this.listener;
                            if (listener == null) break block3;
                            listener.onUserPlay();
                            break block3;
                        }
                        if (!Intrinsics.areEqual((Object)view, (Object)VideoPlayerView2.this.pauseButton)) break block4;
                        player.pause();
                        Listener listener = VideoPlayerView2.this.listener;
                        if (listener == null) break block3;
                        listener.onUserPause();
                        break block3;
                    }
                    if (!Intrinsics.areEqual((Object)view, (Object)VideoPlayerView2.this.volumeOnButton)) break block5;
                    player.setVolume(0.0f);
                    Listener listener = VideoPlayerView2.this.listener;
                    if (listener == null) break block3;
                    listener.onUserMute();
                    break block3;
                }
                if (!Intrinsics.areEqual((Object)view, (Object)VideoPlayerView2.this.volumeOffButton)) break block3;
                player.setVolume(1.0f);
                Listener listener = VideoPlayerView2.this.listener;
                if (listener != null) {
                    listener.onUserUnmute();
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH&J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lcom/particles/android/ads/internal/rendering/video/VideoPlayerView2$Listener;", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController$UserInteractionListener;", "Lcom/particles/android/ads/internal/rendering/video/VideoPlayerController$ProgressUpdateListener;", "onIsPlayingOrBufferingChanged", "", "isPlayingOrBuffering", "", "onPause", "reason", "", "onPlay", "onUserPause", "onUserPlay", "nova-sdk_release"})
    public static interface Listener
    extends VideoPlayerController.UserInteractionListener,
    VideoPlayerController.ProgressUpdateListener {
        public void onIsPlayingOrBufferingChanged(boolean var1);

        public void onPlay(@NotNull String var1);

        public void onPause(@NotNull String var1);

        @Override
        public void onUserPlay();

        @Override
        public void onUserPause();

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void onUserPlay(@NotNull Listener $this) {
                $this.onPlay(VideoPlayerView2.REASON_USER_INTERACTION);
            }

            public static void onUserPause(@NotNull Listener $this) {
                $this.onPause(VideoPlayerView2.REASON_USER_INTERACTION);
            }
        }
    }
}

