/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.tracking;

import com.particles.android.ads.internal.NovaInternal;
import com.particles.android.ads.internal.domain.BrowserExtras;
import com.particles.android.ads.internal.domain.ClickExtras;
import com.particles.android.ads.internal.domain.TrackingEvent;
import com.particles.android.ads.internal.domain.VideoExtras;
import com.particles.android.ads.internal.domain.VideoProgressExtras;
import com.particles.android.ads.internal.domain.ViewabilityExtras;
import com.particles.android.ads.internal.tracking.Tracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/particles/android/ads/internal/tracking/EventTracker;", "Lcom/particles/android/ads/internal/tracking/Tracker;", "()V", "fire", "", "event", "Lcom/particles/android/ads/internal/domain/TrackingEvent;", "nova-sdk_release"})
@SourceDebugExtension(value={"SMAP\nEventTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventTracker.kt\ncom/particles/android/ads/internal/tracking/EventTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n766#2:91\n857#2,2:92\n1855#2,2:94\n*S KotlinDebug\n*F\n+ 1 EventTracker.kt\ncom/particles/android/ads/internal/tracking/EventTracker\n*L\n78#1:91\n78#1:92,2\n78#1:94,2\n*E\n"})
public final class EventTracker
extends Tracker {
    @NotNull
    public static final EventTracker INSTANCE = new EventTracker();

    private EventTracker() {
    }

    /*
     * WARNING - void declaration
     */
    public final void fire(@NotNull TrackingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            Object object;
            Object it;
            String baseUrl = NovaInternal.INSTANCE.getApiServer() + "/logAdEvent";
            HttpUrl.Builder builder = HttpUrl.Companion.get(baseUrl).newBuilder().addQueryParameter("event_type", event.getType()).addQueryParameter("action", event.getAction()).addQueryParameter("os", NovaInternal.INSTANCE.getOsName()).addQueryParameter("osv", NovaInternal.INSTANCE.getOsVersion()).addQueryParameter("cv", NovaInternal.INSTANCE.getAppVersion()).addQueryParameter("user_id", event.getUserId()).addQueryParameter("profile_id", event.getProfileId()).addQueryParameter("session_id", event.getSessionId()).addQueryParameter("ad_unit_id", event.getAdUnitId()).addQueryParameter("encrypted_ad_token", event.getEncryptedAdToken()).addQueryParameter("event_time", String.valueOf(event.getTime()));
            if (event.getReason() != null) {
                builder.addQueryParameter("reason", event.getReason());
            }
            if (event.getOffset() > 0L) {
                builder.addQueryParameter("offset", String.valueOf(event.getOffset()));
            }
            if (event.getDuration() > 0L) {
                builder.addQueryParameter("duration_ms", String.valueOf(event.getDuration()));
            }
            VideoExtras videoExtras = event.getVideoExtras();
            if (videoExtras != null) {
                it = videoExtras;
                boolean bl = false;
                builder.addQueryParameter("is_play_automatically", String.valueOf(((VideoExtras)it).isAutoPlay())).addQueryParameter("is_loop", String.valueOf(((VideoExtras)it).isLoopPlay())).addQueryParameter("is_mute", String.valueOf(((VideoExtras)it).isMutePlay())).addQueryParameter("is_video_clickable", String.valueOf(((VideoExtras)it).isVideoClickable())).addQueryParameter("video_length", String.valueOf(((VideoExtras)it).getDuration())).addQueryParameter("latency_ms", String.valueOf(((VideoExtras)it).getLatency()));
            }
            VideoProgressExtras videoProgressExtras = event.getVideoProgressExtras();
            if (videoProgressExtras != null) {
                it = videoProgressExtras;
                boolean bl = false;
                builder.addQueryParameter("video_length", String.valueOf(((VideoProgressExtras)it).getDuration())).addQueryParameter("position_ms", String.valueOf(((VideoProgressExtras)it).getPosition())).addQueryParameter("loop_count", String.valueOf(((VideoProgressExtras)it).getRepeatCount()));
            }
            ViewabilityExtras viewabilityExtras = event.getViewabilityExtras();
            if (viewabilityExtras != null) {
                it = viewabilityExtras;
                boolean bl = false;
                builder.addQueryParameter("bs", ((ViewabilityExtras)it).getViewportSize()).addQueryParameter("mtos", ((ViewabilityExtras)it).getTimeOnScreenInMillis()).addQueryParameter("p", ((ViewabilityExtras)it).getCreativePosition());
            }
            ClickExtras clickExtras = event.getClickExtras();
            if (clickExtras != null) {
                it = clickExtras;
                boolean bl = false;
                builder.addQueryParameter("click_area_name", ((ClickExtras)it).getClickAreaName());
            }
            BrowserExtras browserExtras = event.getBrowserExtras();
            if (browserExtras != null) {
                it = browserExtras;
                boolean bl = false;
                if (((BrowserExtras)it).getSeq() > 0) {
                    builder.addQueryParameter("seq", String.valueOf(((BrowserExtras)it).getSeq()));
                }
                if (((BrowserExtras)it).getStatus() > 0) {
                    builder.addQueryParameter("status", String.valueOf(((BrowserExtras)it).getStatus()));
                }
                builder.addQueryParameter("page_index", String.valueOf(((BrowserExtras)it).getPageIndex())).addQueryParameter("scroll_depth", String.valueOf(((BrowserExtras)it).getScrollDepth()));
            }
            if ((object = event.getExtras()) != null && (object = object.entrySet()) != null) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = (Iterable)object;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Map.Entry it2 = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!(!StringsKt.startsWith$default((CharSequence)((CharSequence)it2.getKey()), (char)'_', (boolean)false, (int)2, null))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry it3 = (Map.Entry)element$iv;
                    boolean bl = false;
                    builder.addQueryParameter("x_" + (String)it3.getKey(), String.valueOf(it3.getValue()));
                }
            }
            String url = builder.toString();
            this.fire(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

