/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.util;

import android.content.ContentResolver;
import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.particles.android.ads.internal.util.DeviceInfo;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b$\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR)\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0011\u0010\bR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0016\u0010\bR\u001b\u0010\u0018\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u0019\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000f\u001a\u0004\b\u001e\u0010\bR\u001d\u0010 \u001a\u0004\u0018\u00010\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u000f\u001a\u0004\b!\u0010\bR\u0011\u0010#\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\bR\u0013\u0010(\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\bR\u0014\u0010*\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\bR\u0013\u0010,\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\b\u00a8\u0006/"}, d2={"Lcom/particles/android/ads/internal/util/DeviceInfo;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "advertisingId", "", "getAdvertisingId", "()Ljava/lang/String;", "advertisingInfo", "Lkotlin/Pair;", "", "getAdvertisingInfo", "()Lkotlin/Pair;", "advertisingInfo$delegate", "Lkotlin/Lazy;", "appVersion", "getAppVersion", "appVersion$delegate", "brand", "getBrand", "carrier", "getCarrier", "carrier$delegate", "connectionType", "getConnectionType", "connectionType$delegate", "getContext", "()Landroid/content/Context;", "country", "getCountry", "country$delegate", "language", "getLanguage", "language$delegate", "limitAdTrackingEnabled", "getLimitAdTrackingEnabled", "()Z", "manufacturer", "getManufacturer", "model", "getModel", "osName", "getOsName", "osVersion", "getOsVersion", "Companion", "nova-sdk_release"})
public final class DeviceInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy advertisingInfo$delegate;
    @NotNull
    private final Lazy appVersion$delegate;
    @NotNull
    private final String osName;
    @Nullable
    private final String osVersion;
    @Nullable
    private final String brand;
    @Nullable
    private final String manufacturer;
    @Nullable
    private final String model;
    @NotNull
    private final Lazy carrier$delegate;
    @NotNull
    private final Lazy connectionType$delegate;
    @NotNull
    private final Lazy country$delegate;
    @NotNull
    private final Lazy language$delegate;

    public DeviceInfo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.advertisingInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pair<? extends String, ? extends Boolean>>(this){
            final /* synthetic */ DeviceInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Pair<String, Boolean> invoke() {
                return com.particles.android.ads.internal.util.DeviceInfo$Companion.access$getAdvertisingInfo(DeviceInfo.Companion, this.this$0.getContext());
            }
        }));
        this.appVersion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DeviceInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return DeviceInfo.Companion.getAppVersionName(this.this$0.getContext());
            }
        }));
        this.osName = "android";
        this.osVersion = Build.VERSION.RELEASE;
        this.brand = Build.BRAND;
        this.manufacturer = Build.MANUFACTURER;
        this.model = Build.MODEL;
        this.carrier$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DeviceInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return com.particles.android.ads.internal.util.DeviceInfo$Companion.access$getCarrier(DeviceInfo.Companion, this.this$0.getContext());
            }
        }));
        this.connectionType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DeviceInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return com.particles.android.ads.internal.util.DeviceInfo$Companion.access$getConnectionType(DeviceInfo.Companion, this.this$0.getContext());
            }
        }));
        this.country$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DeviceInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return com.particles.android.ads.internal.util.DeviceInfo$Companion.access$getCountry(DeviceInfo.Companion, this.this$0.getContext());
            }
        }));
        this.language$delegate = LazyKt.lazy((Function0)language.2.INSTANCE);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    private final Pair<String, Boolean> getAdvertisingInfo() {
        Lazy lazy = this.advertisingInfo$delegate;
        return (Pair)lazy.getValue();
    }

    @Nullable
    public final String getAdvertisingId() {
        return (String)this.getAdvertisingInfo().getFirst();
    }

    public final boolean getLimitAdTrackingEnabled() {
        return (Boolean)this.getAdvertisingInfo().getSecond();
    }

    @Nullable
    public final String getAppVersion() {
        Lazy lazy = this.appVersion$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getOsName() {
        return this.osName;
    }

    @Nullable
    public final String getOsVersion() {
        return this.osVersion;
    }

    @Nullable
    public final String getBrand() {
        return this.brand;
    }

    @Nullable
    public final String getManufacturer() {
        return this.manufacturer;
    }

    @Nullable
    public final String getModel() {
        return this.model;
    }

    @Nullable
    public final String getCarrier() {
        Lazy lazy = this.carrier$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getConnectionType() {
        Lazy lazy = this.connectionType$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getCountry() {
        Lazy lazy = this.country$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getLanguage() {
        Lazy lazy = this.language$delegate;
        return (String)lazy.getValue();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u001e\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\n\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u0011\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0018"}, d2={"Lcom/particles/android/ads/internal/util/DeviceInfo$Companion;", "", "()V", "generateUUID", "", "getAdvertisingInfo", "Lkotlin/Pair;", "", "context", "Landroid/content/Context;", "getAmazonAdvertisingInfo", "getAppVersionName", "getCarrier", "getConnectionType", "getCountry", "getCountryFromLocation", "getCountryFromNetwork", "getGoogleAdvertisingInfo", "getLanguage", "getMobileNetworkGeneration", "", "type", "getMostRecentLocation", "Landroid/location/Location;", "nova-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String generateUUID() {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Nullable
        public final Location getMostRecentLocation(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return null;
        }

        @Nullable
        public final String getAppVersionName(@NotNull Context context) {
            String string;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            try {
                string = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
            }
            catch (Exception e) {
                string = null;
            }
            return string;
        }

        private final String getCarrier(Context context) {
            String string;
            try {
                Object object = context.getSystemService("phone");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
                TelephonyManager tm = (TelephonyManager)object;
                string = tm.getNetworkOperatorName();
            }
            catch (Exception e) {
                string = null;
            }
            return string;
        }

        private final String getConnectionType(Context context) {
            try {
                String string;
                Object object = context.getSystemService("connectivity");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
                ConnectivityManager cm = (ConnectivityManager)object;
                NetworkInfo activeNetworkInfo = cm.getActiveNetworkInfo();
                if (activeNetworkInfo == null || !activeNetworkInfo.isAvailable() || !activeNetworkInfo.isConnected()) {
                    return "UNKNOWN";
                }
                switch (activeNetworkInfo.getType()) {
                    case 9: {
                        string = "ETH";
                        break;
                    }
                    case 1: {
                        string = "WIFI";
                        break;
                    }
                    case 6: {
                        string = "4G";
                        break;
                    }
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "" + this.getMobileNetworkGeneration(activeNetworkInfo.getSubtype()) + 'G';
                        break;
                    }
                    default: {
                        string = "UNKNOWN";
                    }
                }
                return string;
            }
            catch (Exception e) {
                return "UNKNOWN";
            }
        }

        private final int getMobileNetworkGeneration(int type) {
            int n;
            switch (type) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: 
                case 16: {
                    n = 2;
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 17: {
                    n = 3;
                    break;
                }
                case 13: 
                case 18: {
                    n = 4;
                    break;
                }
                case 20: {
                    n = 5;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }

        private final String getCountry(Context context) {
            String country2 = this.getCountryFromLocation(context);
            CharSequence charSequence = country2;
            if (!(charSequence == null || charSequence.length() == 0)) {
                return country2;
            }
            country2 = this.getCountryFromNetwork(context);
            charSequence = country2;
            if (!(charSequence == null || charSequence.length() == 0)) {
                return country2;
            }
            return Locale.getDefault().getCountry();
        }

        private final String getCountryFromLocation(Context context) {
            Location recent = this.getMostRecentLocation(context);
            if (recent != null) {
                try {
                    Geocoder geocoder;
                    List addresses;
                    if (Geocoder.isPresent() && (addresses = (geocoder = new Geocoder(context, Locale.ENGLISH)).getFromLocation(recent.getLatitude(), recent.getLongitude(), 1)) != null) {
                        for (Address address : addresses) {
                            if (address == null) continue;
                            return address.getCountryCode();
                        }
                    }
                }
                catch (IOException iOException) {
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return null;
        }

        private final String getCountryFromNetwork(Context context) {
            try {
                String country2;
                Object object = context.getSystemService("phone");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
                TelephonyManager tm = (TelephonyManager)object;
                if (tm.getPhoneType() != 2 && (country2 = tm.getNetworkCountryIso()) != null) {
                    String string = country2;
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    String string2 = string.toUpperCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
                    return string2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private final String getLanguage() {
            return Locale.getDefault().getLanguage();
        }

        private final Pair<String, Boolean> getAdvertisingInfo(Context context) {
            return Intrinsics.areEqual((Object)"Amazon", (Object)Build.MANUFACTURER) ? this.getAmazonAdvertisingInfo(context) : this.getGoogleAdvertisingInfo(context);
        }

        private final Pair<String, Boolean> getAmazonAdvertisingInfo(Context context) {
            ContentResolver cr = context.getContentResolver();
            boolean lat = Settings.Secure.getInt((ContentResolver)cr, (String)"limit_ad_tracking", (int)0) == 1;
            String id2 = Settings.Secure.getString((ContentResolver)cr, (String)"advertising_id");
            return new Pair((Object)id2, (Object)lat);
        }

        private final Pair<String, Boolean> getGoogleAdvertisingInfo(Context context) {
            String id2 = null;
            boolean lat = false;
            try {
                Class<?> advertisingIdClient = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
                Class[] classArray = new Class[]{Context.class};
                Method getAdvertisingInfo = advertisingIdClient.getMethod("getAdvertisingIdInfo", classArray);
                Object[] objectArray = new Object[]{context};
                Object advertisingInfo2 = getAdvertisingInfo.invoke(null, objectArray);
                Method isLimitAdTrackingEnabled = advertisingInfo2.getClass().getMethod("isLimitAdTrackingEnabled", new Class[0]);
                Boolean limitAdTrackingEnabled = (Boolean)isLimitAdTrackingEnabled.invoke(advertisingInfo2, new Object[0]);
                lat = limitAdTrackingEnabled != null && limitAdTrackingEnabled != false;
                Method getId = advertisingInfo2.getClass().getMethod("getId", new Class[0]);
                Object object = getId.invoke(advertisingInfo2, new Object[0]);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                id2 = (String)object;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new Pair(id2, (Object)lat);
        }

        public static final /* synthetic */ Pair access$getAdvertisingInfo(Companion $this, Context context) {
            return $this.getAdvertisingInfo(context);
        }

        public static final /* synthetic */ String access$getCarrier(Companion $this, Context context) {
            return $this.getCarrier(context);
        }

        public static final /* synthetic */ String access$getConnectionType(Companion $this, Context context) {
            return $this.getConnectionType(context);
        }

        public static final /* synthetic */ String access$getCountry(Companion $this, Context context) {
            return $this.getCountry(context);
        }

        public static final /* synthetic */ String access$getLanguage(Companion $this) {
            return $this.getLanguage();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

