/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.util;

import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010\u000f\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0018"}, d2={"Lcom/particles/android/ads/internal/util/WebViews;", "", "()V", "getPageIndex", "", "webView", "Landroid/webkit/WebView;", "getScrollDepth", "", "hasGesture", "", "view", "isDeeplink", "uri", "", "onRenderProcessGone", "detail", "Landroid/webkit/RenderProcessGoneDetail;", "setAllowDeviceContentAccess", "", "settings", "Landroid/webkit/WebSettings;", "allow", "setDisableJSChromeClient", "nova-sdk_release"})
public final class WebViews {
    @NotNull
    public static final WebViews INSTANCE = new WebViews();

    private WebViews() {
    }

    public final boolean isDeeplink(@Nullable String uri) {
        return uri != null && !StringsKt.startsWith((String)uri, (String)"http:", (boolean)true) && !StringsKt.startsWith((String)uri, (String)"https:", (boolean)true);
    }

    public final boolean hasGesture(@Nullable WebView view) {
        WebView webView = view;
        WebView.HitTestResult htr = webView != null ? webView.getHitTestResult() : null;
        return htr != null && (7 == htr.getType() || 8 == htr.getType()) && htr.getExtra() != null;
    }

    public final void setAllowDeviceContentAccess(@NotNull WebSettings settings, boolean allow) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        settings.setAllowContentAccess(allow);
        settings.setAllowFileAccess(allow);
        settings.setAllowFileAccessFromFileURLs(allow);
        settings.setAllowUniversalAccessFromFileURLs(allow);
    }

    public final void setDisableJSChromeClient(@NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onJsAlert(@NotNull WebView view, @NotNull String url, @NotNull String message, @NotNull JsResult result) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                result.confirm();
                return true;
            }

            public boolean onJsConfirm(@NotNull WebView view, @NotNull String url, @NotNull String message, @NotNull JsResult result) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                result.confirm();
                return true;
            }

            public boolean onJsPrompt(@NotNull WebView view, @NotNull String url, @NotNull String message, @NotNull String defaultValue, @NotNull JsPromptResult result) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                result.confirm();
                return true;
            }

            public boolean onJsBeforeUnload(@NotNull WebView view, @NotNull String url, @NotNull String message, @NotNull JsResult result) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                result.confirm();
                return true;
            }
        });
    }

    public final int getPageIndex(@NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        if (!webView.canGoBack()) {
            return 0;
        }
        return webView.copyBackForwardList().getCurrentIndex();
    }

    public final float getScrollDepth(@NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        return (float)webView.getScrollY() / ((float)webView.getContentHeight() * webView.getScale() - (float)webView.getHeight());
    }

    public final boolean onRenderProcessGone(@Nullable WebView view, @Nullable RenderProcessGoneDetail detail) {
        block1: {
            WebView webView = view;
            if (webView == null) break block1;
            WebView it = webView;
            boolean bl = false;
            ViewParent viewParent = it.getParent();
            ViewGroup viewGroup = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
            if (viewGroup != null) {
                viewGroup.removeView((View)view);
            }
            view.destroy();
        }
        return true;
    }
}

