/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.util.viewability;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.iab.omid.library.newsbreak1.Omid;
import com.iab.omid.library.newsbreak1.ScriptInjector;
import com.iab.omid.library.newsbreak1.adsession.AdSession;
import com.iab.omid.library.newsbreak1.adsession.AdSessionConfiguration;
import com.iab.omid.library.newsbreak1.adsession.AdSessionContext;
import com.iab.omid.library.newsbreak1.adsession.CreativeType;
import com.iab.omid.library.newsbreak1.adsession.ImpressionType;
import com.iab.omid.library.newsbreak1.adsession.Owner;
import com.iab.omid.library.newsbreak1.adsession.Partner;
import com.iab.omid.library.newsbreak1.adsession.VerificationScriptResource;
import com.particles.android.ads.R;
import com.particles.android.ads.internal.NovaInternal;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class OMSDKUtil {
    private static final String PARTNER_NAME = "Newsbreak1";

    public static String injectScriptContentIntoHtml(Context context, String html) {
        try {
            String omidJs = OMSDKUtil.getOmidJs(context);
            return ScriptInjector.injectScriptContentIntoHtml((String)omidJs, (String)html);
        }
        catch (Exception e) {
            return html;
        }
    }

    @Nullable
    public static AdSession createHtmlAdSession(WebView webView) {
        Omid.activate((Context)webView.getContext());
        if (!Omid.isActive()) {
            return null;
        }
        Partner partner = Partner.createPartner((String)PARTNER_NAME, (String)NovaInternal.INSTANCE.getAppVersion());
        AdSessionContext adSessionContext = AdSessionContext.createHtmlAdSessionContext((Partner)partner, (WebView)webView, (String)"", (String)"");
        AdSessionConfiguration adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration((CreativeType)CreativeType.HTML_DISPLAY, (ImpressionType)ImpressionType.BEGIN_TO_RENDER, (Owner)Owner.NATIVE, (Owner)Owner.NONE, (boolean)false);
        return AdSession.createAdSession((AdSessionConfiguration)adSessionConfiguration, (AdSessionContext)adSessionContext);
    }

    @Nullable
    public static AdSession createNativeAdSession(Context applicationContext, List<String> verificationResourceUrls) {
        Omid.activate((Context)applicationContext);
        if (!Omid.isActive()) {
            return null;
        }
        AdSessionConfiguration adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration((CreativeType)CreativeType.NATIVE_DISPLAY, (ImpressionType)ImpressionType.VIEWABLE, (Owner)Owner.NATIVE, (Owner)Owner.NONE, (boolean)false);
        try {
            Partner partner = Partner.createPartner((String)PARTNER_NAME, (String)NovaInternal.INSTANCE.getAppVersion());
            String omidJs = OMSDKUtil.getOmidJs(applicationContext);
            List<VerificationScriptResource> verificationScripts = OMSDKUtil.getVerificationScriptResources(verificationResourceUrls);
            AdSessionContext adSessionContext = AdSessionContext.createNativeAdSessionContext((Partner)partner, (String)omidJs, verificationScripts, null, (String)"");
            return AdSession.createAdSession((AdSessionConfiguration)adSessionConfiguration, (AdSessionContext)adSessionContext);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static AdSession createNativeVideoSession(Context applicationContext, List<String> verificationResourceUrls) {
        Omid.activate((Context)applicationContext);
        if (!Omid.isActive()) {
            return null;
        }
        AdSessionConfiguration adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration((CreativeType)CreativeType.VIDEO, (ImpressionType)ImpressionType.BEGIN_TO_RENDER, (Owner)Owner.NATIVE, (Owner)Owner.NATIVE, (boolean)false);
        try {
            Partner partner = Partner.createPartner((String)PARTNER_NAME, (String)NovaInternal.INSTANCE.getAppVersion());
            String omidJs = OMSDKUtil.getOmidJs(applicationContext);
            List<VerificationScriptResource> verificationScripts = OMSDKUtil.getVerificationScriptResources(verificationResourceUrls);
            AdSessionContext adSessionContext = AdSessionContext.createNativeAdSessionContext((Partner)partner, (String)omidJs, verificationScripts, null, (String)"");
            return AdSession.createAdSession((AdSessionConfiguration)adSessionConfiguration, (AdSessionContext)adSessionContext);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getOmidJs(Context applicationContext) throws IOException {
        Resources res = applicationContext.getResources();
        InputStream inputStream = res.openRawResource(R.raw.omsdk_v1_4_10);
        byte[] b = new byte[inputStream.available()];
        int bytesRead = inputStream.read(b);
        return new String(b, 0, bytesRead, "UTF-8");
    }

    @NonNull
    private static List<VerificationScriptResource> getVerificationScriptResources(List<String> verificationResourceUrls) throws MalformedURLException {
        ArrayList<VerificationScriptResource> verificationScriptResources = new ArrayList<VerificationScriptResource>();
        if (verificationResourceUrls != null) {
            for (String url : verificationResourceUrls) {
                VerificationScriptResource verificationScriptResource = VerificationScriptResource.createVerificationScriptResourceWithoutParameters((URL)new URL(url));
                verificationScriptResources.add(verificationScriptResource);
            }
        }
        return verificationScriptResources;
    }

    public static void addFriendlyObstructions(View adView, AdSession adSession) {
    }

    private static Context getActivityContext(View view) {
        for (View v = view; v != null && v.getParent() instanceof View; v = (View)v.getParent()) {
            Context context = v.getContext();
            if (!(context instanceof Activity)) continue;
            return context;
        }
        return null;
    }
}

