/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.util.viewability;

import android.view.View;
import android.webkit.WebView;
import com.iab.omid.library.newsbreak1.adsession.AdEvents;
import com.iab.omid.library.newsbreak1.adsession.AdSession;
import com.iab.omid.library.newsbreak1.adsession.FriendlyObstructionPurpose;
import com.iab.omid.library.newsbreak1.adsession.media.Position;
import com.iab.omid.library.newsbreak1.adsession.media.VastProperties;
import com.particles.android.ads.internal.domain.AdVerification;
import com.particles.android.ads.internal.util.viewability.OMMediaEvents;
import com.particles.android.ads.internal.util.viewability.OMSDKUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 !2\u00020\u0001:\u0002!\"B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u0012J\u0006\u0010\u001f\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/particles/android/ads/internal/util/viewability/OMTracker;", "", "adView", "Landroid/view/View;", "adSession", "Lcom/iab/omid/library/newsbreak1/adsession/AdSession;", "mediaExtras", "Lcom/particles/android/ads/internal/util/viewability/OMTracker$MediaExtras;", "(Landroid/view/View;Lcom/iab/omid/library/newsbreak1/adsession/AdSession;Lcom/particles/android/ads/internal/util/viewability/OMTracker$MediaExtras;)V", "adEvents", "Lcom/iab/omid/library/newsbreak1/adsession/AdEvents;", "mediaEvents", "Lcom/particles/android/ads/internal/util/viewability/OMMediaEvents;", "getMediaEvents", "()Lcom/particles/android/ads/internal/util/viewability/OMMediaEvents;", "state", "", "addFriendlyObstruction", "", "view", "purpose", "Lcom/iab/omid/library/newsbreak1/adsession/FriendlyObstructionPurpose;", "reason", "", "changeState", "newState", "createVastProperties", "Lcom/iab/omid/library/newsbreak1/adsession/media/VastProperties;", "extras", "removeFriendlyObstruction", "startTracking", "stopTracking", "trackImpression", "Companion", "MediaExtras", "nova-sdk_release"})
@SourceDebugExtension(value={"SMAP\nOMTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OMTracker.kt\ncom/particles/android/ads/internal/util/viewability/OMTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public final class OMTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final View adView;
    @NotNull
    private final AdSession adSession;
    @Nullable
    private final MediaExtras mediaExtras;
    @NotNull
    private final AdEvents adEvents;
    @Nullable
    private final OMMediaEvents mediaEvents;
    private int state;
    public static final int STATE_IDLE = 0;
    public static final int STATE_STARTED = 1;
    public static final int STATE_IMPRESSED = 2;
    public static final int STATE_STOPPED = 3;

    public OMTracker(@NotNull View adView, @NotNull AdSession adSession, @Nullable MediaExtras mediaExtras) {
        OMMediaEvents oMMediaEvents;
        Intrinsics.checkNotNullParameter((Object)adView, (String)"adView");
        Intrinsics.checkNotNullParameter((Object)adSession, (String)"adSession");
        this.adView = adView;
        this.adSession = adSession;
        this.mediaExtras = mediaExtras;
        AdEvents adEvents = AdEvents.createAdEvents((AdSession)this.adSession);
        Intrinsics.checkNotNullExpressionValue((Object)adEvents, (String)"createAdEvents(...)");
        this.adEvents = adEvents;
        OMTracker oMTracker = this;
        MediaExtras mediaExtras2 = this.mediaExtras;
        if (mediaExtras2 != null) {
            MediaExtras mediaExtras3 = mediaExtras2;
            OMTracker oMTracker2 = oMTracker;
            boolean bl = false;
            oMMediaEvents = new OMMediaEvents(this.adSession);
            oMTracker = oMTracker2;
        } else {
            oMMediaEvents = null;
        }
        oMTracker.mediaEvents = oMMediaEvents;
        this.adSession.registerAdView(this.adView);
        OMSDKUtil.addFriendlyObstructions(this.adView, this.adSession);
    }

    public /* synthetic */ OMTracker(View view, AdSession adSession, MediaExtras mediaExtras, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            mediaExtras = null;
        }
        this(view, adSession, mediaExtras);
    }

    @Nullable
    public final OMMediaEvents getMediaEvents() {
        return this.mediaEvents;
    }

    public final void addFriendlyObstruction(@NotNull View view, @NotNull FriendlyObstructionPurpose purpose, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)purpose, (String)"purpose");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.adSession.addFriendlyObstruction(view, purpose, reason);
    }

    public static /* synthetic */ void addFriendlyObstruction$default(OMTracker oMTracker, View view, FriendlyObstructionPurpose friendlyObstructionPurpose, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        oMTracker.addFriendlyObstruction(view, friendlyObstructionPurpose, string);
    }

    public final void removeFriendlyObstruction(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.adSession.removeFriendlyObstruction(view);
    }

    public final void startTracking() {
        this.changeState(1);
    }

    public final void stopTracking() {
        this.changeState(3);
    }

    public final void trackImpression() {
        this.changeState(2);
    }

    private final void changeState(int newState) {
        switch (newState) {
            case 1: {
                if (this.state != 0) break;
                this.adSession.start();
                if (this.mediaExtras != null) {
                    this.adEvents.loaded(this.createVastProperties(this.mediaExtras));
                } else {
                    this.adEvents.loaded();
                }
                this.state = newState;
                break;
            }
            case 2: {
                if (this.state != 1) break;
                this.adEvents.impressionOccurred();
                this.state = newState;
                break;
            }
            case 3: {
                if (this.state == 0 || this.state == 3) break;
                this.adSession.finish();
                this.state = newState;
            }
        }
    }

    private final VastProperties createVastProperties(MediaExtras extras) {
        VastProperties vastProperties;
        if (extras.getSkipOffset() >= 0.0f) {
            VastProperties vastProperties2 = VastProperties.createVastPropertiesForSkippableMedia((float)extras.getSkipOffset(), (boolean)extras.isAutoPlay(), (Position)Position.STANDALONE);
            vastProperties = vastProperties2;
            Intrinsics.checkNotNullExpressionValue((Object)vastProperties2, (String)"createVastPropertiesForSkippableMedia(...)");
        } else {
            VastProperties vastProperties3 = VastProperties.createVastPropertiesForNonSkippableMedia((boolean)extras.isAutoPlay(), (Position)Position.STANDALONE);
            vastProperties = vastProperties3;
            Intrinsics.checkNotNullExpressionValue((Object)vastProperties3, (String)"createVastPropertiesForNonSkippableMedia(...)");
        }
        return vastProperties;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ&\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/particles/android/ads/internal/util/viewability/OMTracker$Companion;", "", "()V", "STATE_IDLE", "", "STATE_IMPRESSED", "STATE_STARTED", "STATE_STOPPED", "createNativeDisplayTracker", "Lcom/particles/android/ads/internal/util/viewability/OMTracker;", "adView", "Landroid/view/View;", "adVerifications", "", "Lcom/particles/android/ads/internal/domain/AdVerification;", "createNativeVideoTracker", "extras", "Lcom/particles/android/ads/internal/util/viewability/OMTracker$MediaExtras;", "createWebViewDisplayTracker", "webView", "Landroid/webkit/WebView;", "nova-sdk_release"})
    @SourceDebugExtension(value={"SMAP\nOMTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OMTracker.kt\ncom/particles/android/ads/internal/util/viewability/OMTracker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1549#2:127\n1620#2,3:128\n1549#2:131\n1620#2,3:132\n*S KotlinDebug\n*F\n+ 1 OMTracker.kt\ncom/particles/android/ads/internal/util/viewability/OMTracker$Companion\n*L\n101#1:127\n101#1:128,3\n114#1:131\n114#1:132,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final OMTracker createWebViewDisplayTracker(@NotNull WebView webView, @NotNull View adView) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            Intrinsics.checkNotNullParameter((Object)adView, (String)"adView");
            try {
                AdSession adSession = OMSDKUtil.createHtmlAdSession(webView);
                if (adSession != null) {
                    return new OMTracker(adView, adSession, null, 4, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public static /* synthetic */ OMTracker createWebViewDisplayTracker$default(Companion companion, WebView webView, View view, int n, Object object) {
            if ((n & 2) != 0) {
                view = (View)webView;
            }
            return companion.createWebViewDisplayTracker(webView, view);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final OMTracker createNativeDisplayTracker(@NotNull View adView, @NotNull List<AdVerification> adVerifications) {
            Intrinsics.checkNotNullParameter((Object)adView, (String)"adView");
            Intrinsics.checkNotNullParameter(adVerifications, (String)"adVerifications");
            try {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = adVerifications;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AdVerification adVerification = (AdVerification)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getJavascriptResourceUrl());
                }
                List urls = (List)destination$iv$iv;
                AdSession adSession = OMSDKUtil.createNativeAdSession(adView.getContext(), urls);
                if (adSession != null) {
                    return new OMTracker(adView, adSession, null, 4, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final OMTracker createNativeVideoTracker(@NotNull View adView, @NotNull List<AdVerification> adVerifications, @NotNull MediaExtras extras) {
            Intrinsics.checkNotNullParameter((Object)adView, (String)"adView");
            Intrinsics.checkNotNullParameter(adVerifications, (String)"adVerifications");
            Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
            try {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = adVerifications;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AdVerification adVerification = (AdVerification)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getJavascriptResourceUrl());
                }
                List urls = (List)destination$iv$iv;
                AdSession adSession = OMSDKUtil.createNativeVideoSession(adView.getContext(), urls);
                if (adSession != null) {
                    return new OMTracker(adView, adSession, extras);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/particles/android/ads/internal/util/viewability/OMTracker$MediaExtras;", "", "isAutoPlay", "", "skipOffset", "", "(ZF)V", "()Z", "getSkipOffset", "()F", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "nova-sdk_release"})
    public static final class MediaExtras {
        private final boolean isAutoPlay;
        private final float skipOffset;

        public MediaExtras(boolean isAutoPlay, float skipOffset) {
            this.isAutoPlay = isAutoPlay;
            this.skipOffset = skipOffset;
        }

        public /* synthetic */ MediaExtras(boolean bl, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                f = -1.0f;
            }
            this(bl, f);
        }

        public final boolean isAutoPlay() {
            return this.isAutoPlay;
        }

        public final float getSkipOffset() {
            return this.skipOffset;
        }

        public final boolean component1() {
            return this.isAutoPlay;
        }

        public final float component2() {
            return this.skipOffset;
        }

        @NotNull
        public final MediaExtras copy(boolean isAutoPlay, float skipOffset) {
            return new MediaExtras(isAutoPlay, skipOffset);
        }

        public static /* synthetic */ MediaExtras copy$default(MediaExtras mediaExtras, boolean bl, float f, int n, Object object) {
            if ((n & 1) != 0) {
                bl = mediaExtras.isAutoPlay;
            }
            if ((n & 2) != 0) {
                f = mediaExtras.skipOffset;
            }
            return mediaExtras.copy(bl, f);
        }

        @NotNull
        public String toString() {
            return "MediaExtras(isAutoPlay=" + this.isAutoPlay + ", skipOffset=" + this.skipOffset + ')';
        }

        public int hashCode() {
            int n = this.isAutoPlay ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result = n;
            result = result * 31 + Float.hashCode(this.skipOffset);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MediaExtras)) {
                return false;
            }
            MediaExtras mediaExtras = (MediaExtras)other;
            if (this.isAutoPlay != mediaExtras.isAutoPlay) {
                return false;
            }
            return Float.compare(this.skipOffset, mediaExtras.skipOffset) == 0;
        }

        public MediaExtras() {
            this(false, 0.0f, 3, null);
        }
    }
}

