/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.util.viewability;

import android.content.res.Resources;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.view.View;
import com.particles.android.ads.internal.util.viewability.Snapshot;
import com.particles.android.ads.internal.util.viewability.ViewabilityState;
import com.particles.android.ads.internal.util.viewability.VisibleTimeCounter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\nH\u0002J\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/particles/android/ads/internal/util/viewability/ViewabilityChecker;", "", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "counter", "Lcom/particles/android/ads/internal/util/viewability/VisibleTimeCounter;", "firstVisibleNotified", "", "snapshot", "Lcom/particles/android/ads/internal/util/viewability/Snapshot;", "tempLocation", "", "tempRect", "Landroid/graphics/Rect;", "getState", "Lcom/particles/android/ads/internal/util/viewability/ViewabilityState;", "getViewabilitySnapshot", "hasChanged", "reset", "", "nova-sdk_release"})
public final class ViewabilityChecker {
    @NotNull
    private final View view;
    private boolean firstVisibleNotified;
    @Nullable
    private Snapshot snapshot;
    @NotNull
    private final VisibleTimeCounter counter;
    @NotNull
    private final Rect tempRect;
    @NotNull
    private final int[] tempLocation;

    public ViewabilityChecker(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        int[] nArray = new int[]{100, 75, 50, 25, 1};
        this.counter = new VisibleTimeCounter(nArray);
        this.tempRect = new Rect();
        nArray = new int[]{0, 0};
        this.tempLocation = nArray;
    }

    public final void reset() {
        this.firstVisibleNotified = false;
        this.snapshot = null;
        this.counter.reset();
    }

    public final boolean hasChanged() {
        Snapshot snapshot = this.getViewabilitySnapshot();
        boolean changed = this.counter.update(snapshot.getVisiblePercent(), snapshot.getUpdatedAt());
        if (!this.firstVisibleNotified && snapshot.getVisiblePixels() > 0L) {
            this.firstVisibleNotified = true;
            changed = true;
        }
        this.snapshot = snapshot;
        return changed;
    }

    private final Snapshot getViewabilitySnapshot() {
        DisplayMetrics displayMetrics;
        Resources resources = this.view.getResources();
        Object object = displayMetrics = resources != null ? resources.getDisplayMetrics() : null;
        if (!this.view.isShown() || this.view.getWindowVisibility() != 0 || !this.view.getGlobalVisibleRect(this.tempRect)) {
            this.tempRect.setEmpty();
        }
        this.view.getLocationOnScreen(this.tempLocation);
        DisplayMetrics displayMetrics2 = displayMetrics;
        DisplayMetrics displayMetrics3 = displayMetrics;
        DisplayMetrics displayMetrics4 = displayMetrics;
        return new Snapshot(System.currentTimeMillis(), displayMetrics2 != null ? displayMetrics2.density : 0.0f, displayMetrics3 != null ? displayMetrics3.widthPixels : 0, displayMetrics4 != null ? displayMetrics4.heightPixels : 0, this.tempLocation[1], this.tempLocation[0], this.tempLocation[0] + this.view.getWidth(), this.tempLocation[1] + this.view.getHeight(), this.tempRect.top, this.tempRect.left, this.tempRect.right, this.tempRect.bottom);
    }

    @NotNull
    public final ViewabilityState getState() {
        Snapshot snapshot = this.snapshot;
        Snapshot snapshot2 = this.snapshot;
        Snapshot snapshot3 = this.snapshot;
        Snapshot snapshot4 = this.snapshot;
        Snapshot snapshot5 = this.snapshot;
        Snapshot snapshot6 = this.snapshot;
        Snapshot snapshot7 = this.snapshot;
        Snapshot snapshot8 = this.snapshot;
        Snapshot snapshot9 = this.snapshot;
        Snapshot snapshot10 = this.snapshot;
        return new ViewabilityState(snapshot != null ? snapshot.getViewportWidth() : 0, snapshot2 != null ? snapshot2.getViewportHeight() : 0, snapshot3 != null ? snapshot3.getViewTop() : 0, snapshot4 != null ? snapshot4.getViewLeft() : 0, snapshot5 != null ? snapshot5.getViewRight() : 0, snapshot6 != null ? snapshot6.getViewBottom() : 0, snapshot7 != null ? snapshot7.getVisibleTop() : 0, snapshot8 != null ? snapshot8.getVisibleLeft() : 0, snapshot9 != null ? snapshot9.getVisibleRight() : 0, snapshot10 != null ? snapshot10.getVisibleBottom() : 0, this.counter.getVisibleTime(100), this.counter.getVisibleTime(75), this.counter.getVisibleTime(50), this.counter.getVisibleTime(25), this.counter.getVisibleTime(1));
    }
}

