/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.util.viewability;

import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewTreeObserver;
import com.particles.android.ads.internal.util.viewability.ViewabilityChecker;
import com.particles.android.ads.internal.util.viewability.ViewabilityState;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B:\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012!\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0018\u001a\u00020\fH\u0002J\u0006\u0010\u0019\u001a\u00020\fJ\u0006\u0010\u001a\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/particles/android/ads/internal/util/viewability/ViewabilityTracker;", "", "view", "Landroid/view/View;", "handler", "Landroid/os/Handler;", "onViewabilityChanged", "Lkotlin/Function1;", "Lcom/particles/android/ads/internal/util/viewability/ViewabilityState;", "Lkotlin/ParameterName;", "name", "state", "", "(Landroid/view/View;Landroid/os/Handler;Lkotlin/jvm/functions/Function1;)V", "heartbeatRunnable", "Ljava/lang/Runnable;", "isScheduled", "", "isTracking", "onPreDrawListener", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "viewabilityChecker", "Lcom/particles/android/ads/internal/util/viewability/ViewabilityChecker;", "viewabilityRunnable", "scheduleViewabilityCheck", "startTracking", "stopTracking", "nova-sdk_release"})
public final class ViewabilityTracker {
    @NotNull
    private final View view;
    @NotNull
    private final Handler handler;
    @NotNull
    private final Function1<ViewabilityState, Unit> onViewabilityChanged;
    private boolean isTracking;
    private boolean isScheduled;
    @NotNull
    private final ViewabilityChecker viewabilityChecker;
    @NotNull
    private final ViewTreeObserver.OnPreDrawListener onPreDrawListener;
    @NotNull
    private final Runnable viewabilityRunnable;
    @NotNull
    private final Runnable heartbeatRunnable;

    public ViewabilityTracker(@NotNull View view, @NotNull Handler handler, @NotNull Function1<? super ViewabilityState, Unit> onViewabilityChanged) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(onViewabilityChanged, (String)"onViewabilityChanged");
        this.view = view;
        this.handler = handler;
        this.onViewabilityChanged = onViewabilityChanged;
        this.viewabilityChecker = new ViewabilityChecker(this.view);
        this.onPreDrawListener = () -> ViewabilityTracker.onPreDrawListener$lambda$0(this);
        this.viewabilityRunnable = () -> ViewabilityTracker.viewabilityRunnable$lambda$1(this);
        this.heartbeatRunnable = () -> ViewabilityTracker.heartbeatRunnable$lambda$2(this);
    }

    public /* synthetic */ ViewabilityTracker(View view, Handler handler, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            handler = new Handler(Looper.getMainLooper());
        }
        this(view, handler, (Function1<? super ViewabilityState, Unit>)function1);
    }

    public final void startTracking() {
        if (!this.isTracking) {
            this.isTracking = true;
            ViewTreeObserver observer = this.view.getViewTreeObserver();
            if (observer != null && observer.isAlive()) {
                observer.addOnPreDrawListener(this.onPreDrawListener);
            }
            this.scheduleViewabilityCheck();
        }
    }

    public final void stopTracking() {
        if (this.isTracking) {
            this.isTracking = false;
            ViewTreeObserver observer = this.view.getViewTreeObserver();
            if (observer != null && observer.isAlive()) {
                observer.removeOnPreDrawListener(this.onPreDrawListener);
            }
            this.handler.removeMessages(0);
            this.isScheduled = false;
            this.viewabilityChecker.reset();
        }
    }

    private final void scheduleViewabilityCheck() {
        if (this.isScheduled) {
            return;
        }
        this.isScheduled = true;
        this.handler.removeCallbacks(this.heartbeatRunnable);
        this.handler.postDelayed(this.viewabilityRunnable, 100L);
    }

    private static final boolean onPreDrawListener$lambda$0(ViewabilityTracker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.isTracking) {
            this$0.scheduleViewabilityCheck();
        }
        return true;
    }

    private static final void viewabilityRunnable$lambda$1(ViewabilityTracker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isScheduled = false;
        if (this$0.viewabilityChecker.hasChanged()) {
            this$0.onViewabilityChanged.invoke((Object)this$0.viewabilityChecker.getState());
        }
        this$0.handler.postDelayed(this$0.heartbeatRunnable, 900L);
    }

    private static final void heartbeatRunnable$lambda$2(ViewabilityTracker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.isTracking) {
            this$0.scheduleViewabilityCheck();
        }
    }
}

