/*
 * Decompiled with CFR 0.152.
 */
package com.particles.android.ads.internal.util.viewability;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/particles/android/ads/internal/util/viewability/VisibleTimeCounter;", "", "thresholds", "", "", "([I)V", "startedTimes", "", "", "visibleTimes", "compareAndSetMaxValue", "", "array", "index", "newValue", "", "getVisibleTime", "threshold", "reset", "", "update", "percent", "updatedAt", "nova-sdk_release"})
@SourceDebugExtension(value={"SMAP\nVisibleTimeCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisibleTimeCounter.kt\ncom/particles/android/ads/internal/util/viewability/VisibleTimeCounter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1864#2,3:53\n*S KotlinDebug\n*F\n+ 1 VisibleTimeCounter.kt\ncom/particles/android/ads/internal/util/viewability/VisibleTimeCounter\n*L\n16#1:53,3\n*E\n"})
public final class VisibleTimeCounter {
    @NotNull
    private final List<Integer> thresholds;
    @NotNull
    private final long[] visibleTimes;
    @NotNull
    private final long[] startedTimes;

    public VisibleTimeCounter(int ... thresholds) {
        Intrinsics.checkNotNullParameter((Object)thresholds, (String)"thresholds");
        this.thresholds = ArraysKt.asList((int[])thresholds);
        this.visibleTimes = new long[thresholds.length];
        this.startedTimes = new long[thresholds.length];
    }

    public final void reset() {
        ArraysKt.fill$default((long[])this.visibleTimes, (long)0L, (int)0, (int)0, (int)4, null);
        ArraysKt.fill$default((long[])this.startedTimes, (long)0L, (int)0, (int)0, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean update(int percent, long updatedAt) {
        boolean changed = false;
        Iterable $this$forEachIndexed$iv = this.thresholds;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void threshold;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = ((Number)item$iv).intValue();
            int index = n;
            boolean bl = false;
            if (percent < threshold) {
                if (this.startedTimes[index] <= 0L) continue;
                changed |= this.compareAndSetMaxValue(this.visibleTimes, index, updatedAt - this.startedTimes[index]);
                this.startedTimes[index] = 0L;
                continue;
            }
            if (this.startedTimes[index] > 0L) {
                changed |= this.compareAndSetMaxValue(this.visibleTimes, index, updatedAt - this.startedTimes[index]);
                continue;
            }
            this.startedTimes[index] = updatedAt;
        }
        return changed;
    }

    public static /* synthetic */ boolean update$default(VisibleTimeCounter visibleTimeCounter, int n, long l, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l = System.currentTimeMillis();
        }
        return visibleTimeCounter.update(n, l);
    }

    public final long getVisibleTime(int threshold) {
        int index = this.thresholds.indexOf(threshold);
        if (index >= 0) {
            return this.visibleTimes[index];
        }
        return 0L;
    }

    private final boolean compareAndSetMaxValue(long[] array, int index, long newValue) {
        if (index >= 0 && index < array.length && newValue > array[index]) {
            array[index] = newValue;
            return true;
        }
        return false;
    }
}

