package com.particles.android.ads

import android.os.Bundle
import android.view.Window
import androidx.appcompat.app.AppCompatActivity
import com.particles.android.ads.internal.rendering.fullscreen.ActivityDelegate
import com.particles.android.ads.internal.AppOpenAdImpl
import com.particles.android.ads.internal.BaseAdImpl
import com.particles.android.ads.internal.InterstitialAdImpl
import com.particles.android.ads.internal.NativeAdImpl
import com.particles.android.ads.internal.rendering.fullscreen.NativeInterstitialDelegate
import com.particles.android.ads.internal.util.AdBank

class AdActivity : AppCompatActivity() {

    companion object {
        const val EXTRA_AD_KEY = "ad_key"
    }

    private var delegate: ActivityDelegate? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        supportRequestWindowFeature(Window.FEATURE_NO_TITLE)
        super.onCreate(savedInstanceState)

        val ad = intent.getStringExtra(EXTRA_AD_KEY)?.let { AdBank.get(it) }

        delegate = when (ad) {
            is NativeAdImpl,
            is AppOpenAdImpl,
            is InterstitialAdImpl ->
                NativeInterstitialDelegate(this, ad as BaseAdImpl)

            else -> null
        }

        delegate?.onCreate(savedInstanceState)

        if (delegate == null) finish()
    }

    override fun onStart() {
        super.onStart()
        delegate?.onStart()
    }

    override fun onResume() {
        super.onResume()
        delegate?.onResume()
    }

    override fun onPause() {
        super.onPause()
        delegate?.onPause()
    }

    override fun onStop() {
        super.onStop()
        delegate?.onStop()
    }

    override fun onDestroy() {
        super.onDestroy()
        delegate?.onDestroy()
    }
}
