package com.particles.android.ads

import android.Manifest
import android.content.Context
import androidx.annotation.RequiresPermission
import com.particles.android.ads.appopen.AppOpenAd
import com.particles.android.ads.banner.BannerAd
import com.particles.android.ads.internal.loader.AppOpenAdLoader
import com.particles.android.ads.internal.loader.BannerAdLoader
import com.particles.android.ads.internal.loader.InterstitialAdLoader
import com.particles.android.ads.internal.loader.NativeAdLoader
import com.particles.android.ads.interstitial.InterstitialAd
import com.particles.android.ads.nativead.NativeAd

interface AdLoader {
    @RequiresPermission(Manifest.permission.INTERNET)
    fun loadAd(adRequest: AdRequest) {
        loadAds(adRequest, 1)
    }

    @RequiresPermission(Manifest.permission.INTERNET)
    fun loadAds(adRequest: AdRequest, maxNumberOfAds: Int)

    class Builder(private val context: Context, private val adUnitId: String) {
        private var adLoader: AdLoader? = null

        fun forAppOpenAd(listener: AdLoadListener<AppOpenAd>) = apply {
            adLoader = AppOpenAdLoader(context, adUnitId, listener)
        }

        fun forBannerAd(listener: AdLoadListener<BannerAd>) = apply {
            adLoader = BannerAdLoader(context, adUnitId, listener)
        }

        fun forInterstitialAd(listener: AdLoadListener<InterstitialAd>) = apply {
            adLoader = InterstitialAdLoader(context, adUnitId, listener)
        }

        fun forNativeAd(listener: AdLoadListener<NativeAd>) = apply {
            adLoader = NativeAdLoader(context, adUnitId, listener)
        }

        fun build(): AdLoader? {
            return adLoader
        }
    }
}
