package com.particles.android.ads

import android.content.Context
import com.particles.android.ads.internal.NovaInternal
import java.util.concurrent.atomic.AtomicBoolean

object NovaSdk {
    private val isInitialized = AtomicBoolean(false)

    private lateinit var applicationContext: Context

    internal fun getContext(): Context {
        if (!isInitialized.get()) {
            throw IllegalStateException("Nova sdk is not initialized. Call initialize() first.")
        }

        return applicationContext
    }

    @JvmStatic
    fun initialize(
        context: Context,
        apiServer: String,
        callback: InitCallback? = null,
    ) {
        if (isInitialized.get()) {
            return
        }

        isInitialized.set(true)
        NovaInternal.apiServer = apiServer
        this.applicationContext = context.applicationContext
        callback?.onInitialized()
    }

    fun interface InitCallback {
        fun onInitialized()
    }
}