package com.particles.android.ads.browser

import android.content.Intent
import android.view.ViewGroup
import com.particles.android.ads.R
import com.particles.android.ads.internal.NativeAdImpl
import com.particles.android.ads.internal.rendering.MediaViewVideoRenderer2
import com.particles.android.ads.internal.util.AdBank
import com.particles.android.ads.nativead.NativeAd

class BrowserMediaHeader(
    val ad: NativeAdImpl,
) {
    val floating = /* TODO: AdsFeatureGating.isEnableNovaBrowserVideoFloating() */ false 
            && ad.mediaLayoutType == NativeAd.MediaLayoutType.VERTICAL

    fun attach(container: ViewGroup?) {
        val renderer = container?.findViewById<MediaViewVideoRenderer2>(R.id.media_header)
        if (renderer != null) {
            with (ad.adSession.adPlaybackState) {
                // skip show cover image
                if (position < 0) {
                    position = 0
                }
                // always auto play here
                if (!playWhenReady) {
                    playWhenReady = true
                }
            }
            renderer.setNativeAd(ad, null)
        }
    }

    companion object {
        private const val EXTRA_MEDIA_HEADER_AD_KEY = "media_header_ad_key"

        fun putAdToIntent(ad: NativeAdImpl, intent: Intent) {
            if (ad.creativeType == NativeAd.CreativeType.VIDEO && ad.creative.video != null) {
                intent.putExtra(EXTRA_MEDIA_HEADER_AD_KEY, AdBank.put(ad))
            }
        }

        fun getAdFromIntent(intent: Intent): NativeAdImpl? {
            return intent.getStringExtra(EXTRA_MEDIA_HEADER_AD_KEY)?.let { AdBank.get(it) } as? NativeAdImpl
        }

        fun obtain(intent: Intent): BrowserMediaHeader? {
            return getAdFromIntent(intent)?.let { BrowserMediaHeader(it) }
        }
    }
}
