package com.particles.android.ads.browser

import android.annotation.SuppressLint
import android.content.Context
import android.util.AttributeSet
import android.webkit.CookieManager
import android.webkit.WebSettings
import java.lang.Exception

class BrowserWebView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = android.R.attr.webViewStyle
) : NestedWebView(context, attrs, defStyleAttr) {

    init {
        // restrict device content access
        settings.allowFileAccess = false
        settings.allowContentAccess = false

        // enable javascript
        @SuppressLint("SetJavaScriptEnabled")
        settings.javaScriptEnabled = true
        settings.domStorageEnabled = true

        // screen adaptation
        settings.useWideViewPort = true
        settings.loadWithOverviewMode = true

        // zoom
        settings.textZoom = 100
        settings.setSupportZoom(true)
        settings.builtInZoomControls = true
        settings.displayZoomControls = false

        // support mixed content mode
        settings.mixedContentMode = WebSettings.MIXED_CONTENT_ALWAYS_ALLOW
    }

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        try {
            CookieManager.getInstance().setAcceptThirdPartyCookies(this, true)
        } catch (e: Exception) {
            // ignore
        }
    }
}
