package com.particles.android.ads.internal

import android.app.Activity
import android.content.Intent
import com.particles.android.ads.AdActivity
import com.particles.android.ads.appopen.AppOpenAd
import com.particles.android.ads.appopen.AppOpenAdListener
import com.particles.android.ads.internal.domain.AdSession
import com.particles.android.ads.internal.util.AdBank
import java.io.File

class AppOpenAdImpl(adSession: AdSession) : AppOpenAd, BaseAdImpl(adSession) {

    override fun setAdListener(listener: AppOpenAdListener) {
        this.adListener = listener
    }

    override fun show(activity: Activity) {
        val intent = Intent(activity, AdActivity::class.java)
        intent.putExtra(AdActivity.EXTRA_AD_KEY, AdBank.put(this))
        activity.startActivity(intent)

        adSession.ad.localCachePath
            ?.takeIf { it.isNotEmpty() }
            ?.let { File(it).delete() }
    }

    override fun onAdDismissed(reason: String?) {
        super.onAdDismissed(reason)
        if (adListener is AppOpenAdListener) {
            (adListener as AppOpenAdListener).onAdDismissed()
        }
    }

}
