package com.particles.android.ads.internal

import android.view.View
import com.particles.android.ads.internal.domain.AbConfig
import com.particles.android.ads.BaseAd
import com.particles.android.ads.internal.domain.AdSession
import com.particles.android.ads.internal.domain.AdViewability
import com.particles.android.ads.internal.domain.TrackingEvent
import com.particles.android.ads.internal.tracking.EventTracker

open class BaseAdImpl(val adSession: AdSession) : BaseAd {

    val extras = mutableMapOf<String, Any?>()

    override val adId: String
        get() = adSession.ad.adId

    override val adSetId: String
        get() = adSession.ad.adSetId

    override val adUnitId: String
        get() = adSession.adUnitId

    override val requestId: String
        get() = adSession.id

    override val isAvailable: Boolean
        get() = System.currentTimeMillis().let {
            adSession.ad.startTimeMillis <= it && it < adSession.ad.expireTimeMillis
        }

    override val price: Double
        get() = adSession.ad.price

    override val shareLink: String
        get() = adSession.ad.creative.clickThroughUrl

    override val abConfig: AbConfig
        get() = adSession.ad.abConfig

    override fun setExtras(extras: Map<String, Any?>?) {
        this.extras.clear()
        extras?.let { this.extras.putAll(it) }
    }

    override fun addExtra(key: String, value: Any?) {
        this.extras[key] = value
    }

    internal var adListener: AdListener? = null

    fun onAdImpressed(view: View) {
        if (adSession.adImpressedAt > 0L) {
            return
        }
        adSession.onAdImpressed(extras)

        val urls = adSession.ad.creative.impressionTrackingUrls
        EventTracker.fire(urls)

        this.adListener?.onAdImpressed()
    }

    fun onAdViewableImpressed(view: View, adViewability: AdViewability) {
        if (adSession.adViewableImpressedAt > 0L) {
            return
        }
        adSession.onAdViewableImpressed(adViewability, extras)
    }

    fun onAdClicked(view: View, clickAreaName: String? = null, url: String? = null) {
        adSession.onAdClicked(clickAreaName, extras)
        AdClickHandler(view).handleClick(this, url)

        val urls = adSession.ad.creative.clickTrackingUrls
        EventTracker.fire(urls)

        this.adListener?.onAdClicked()
    }

    fun onAdHidden(reason: String?) {
        if (!adSession.isAdHidden) {
            adSession.onAdHidden(reason, extras)
        }
    }

    fun onAdUnhidden() {
        if (adSession.isAdHidden) {
            adSession.onAdUnhidden(extras)
        }
    }

    open fun onAdDismissed(reason: String?) {
        val type = TrackingEvent.EVENT_TYPE_DISMISS_AD
        if (adSession.adEventTime(type) > 0L) {
            return
        }
        adSession.onAdDismissed(reason, extras)
    }
}
