package com.particles.android.ads.internal

import com.particles.android.ads.nativead.NativeAd
import com.particles.android.ads.internal.domain.AdSession
import com.particles.android.ads.internal.domain.Addon
import com.particles.android.ads.internal.domain.DisplayCardAddon
import com.particles.android.ads.internal.domain.Image
import com.particles.android.ads.nativead.AddonListener
import com.particles.android.ads.nativead.MediaListener
import com.particles.android.ads.nativead.NativeAdListener

class NativeAdImpl(adSession: AdSession) : NativeAd, BaseAdImpl(adSession) {

    val creative = adSession.ad.creative

    override val creativeType = when (creative.type) {
        "IMAGE", "PLAYABLE_IMAGE" -> NativeAd.CreativeType.IMAGE
        "VIDEO", "PLAYABLE_VIDEO" -> NativeAd.CreativeType.VIDEO
        "CAROUSEL" -> NativeAd.CreativeType.CAROUSEL
        "SPONSORED_IMAGE" -> NativeAd.CreativeType.SPONSORED_IMAGE
        else -> NativeAd.CreativeType.UNKNOWN
    }

    override val headline: String
        get() = creative.headline

    override val body: String
        get() = creative.body

    override val icon: NativeAd.Image?
        get() = creative.icon?.let { ImageImpl(it) }

    override val images: List<NativeAd.Image>
        get() = creative.images.map { ImageImpl(it) }

    override val callToAction: String
        get() = creative.callToAction

    override val advertiser: String
        get() = creative.advertiser

    override val starRating: Double
        get() = creative.starRating
    override val addon: NativeAd.Addon?
        get() = creative.addon?.let { AddonImpl(it) }
    override val mediaLayoutType: NativeAd.MediaLayoutType
        get() = when (creative.mediaLayoutType) {
            "vertical" -> NativeAd.MediaLayoutType.VERTICAL
            "vertical_no_text" -> NativeAd.MediaLayoutType.VERTICAL_NO_TEXT
            "interscroller" -> NativeAd.MediaLayoutType.INTER_SCROLLER
            "taller" -> NativeAd.MediaLayoutType.TALLER
            else -> NativeAd.MediaLayoutType.HORIZONTAL
        }

    override var mediaListener: MediaListener? = null

    override var addonListener: AddonListener? = null

    override fun setAdListener(listener: NativeAdListener) {
        this.adListener = listener
    }

    override fun destroy() {
        this.adListener = null
    }

    private class ImageImpl(val base: Image) : NativeAd.Image {
        override val uri: String
            get() = base.url

        override val width: Int
            get() = base.width

        override val height: Int
            get() = base.height
    }

    private class AddonImpl(base: Addon) : NativeAd.Addon {
        override val duration: Int = if (base is DisplayCardAddon) base.displayTime else 0
    }

}
