package com.particles.android.ads.internal.data.entity

data class AdEntity(
    val raw: String,
    val requestId: String,
    val adId: String,
    val adSetId: String,
    val creative: CreativeEntity,
    val price: Double,
    val startTimeMs: Long,
    val expirationMs: Long,
    val encryptedAdToken: String,
    var abConfig: Map<String, String>? = null,
)

data class CreativeEntity(
    val adm: String,
    val ctrUrl: String,
    val headline: String,
    val body: String,
    val callToAction: String,
    val iconUrl: String,
    val imageUrl: String,
    val imageScaleMode: String,
    val imageUrls: List<String>,
    val isImageClickable: Boolean,
    val isVerticalImage: Boolean,
    val address: String,
    val advertiser: String,
    val creativeType: String,
    val layout: String,
    val thirdPartyImpressionTrackingUrls: List<String>,
    val thirdPartyViewTrackingUrls: List<String>,
    val thirdPartyClickTrackingUrls: List<String>,
    val launchOption: String,
    val campaignObjective: String,
    val adBundleId: String,
    val carouselItems: List<CarouselItemEntity>,
    val videoItem: VideoItemEntity?,
    val addonItem: AddonItemEntity?,
    val playableItem: PlayableItemEntity?,
)

data class CarouselItemEntity(
    val ctrUrl: String,
    val body: String,
    val callToAction: String,
    val imageUrl: String,
)

data class VideoItemEntity(
    val videoUrl: String,
    val coverUrl: String,
    val isPlayAutomatically: Boolean,
    val isMute: Boolean,
    val isLoop: Boolean,
    val isVideoClickable: Boolean,
    val isVertical: Boolean,
    val isPlayOnLandingPage: Boolean,
)

data class AddonItemEntity(
    val type: String,
    val imageUrl: String,
    val displayTime: Int,
)

data class PlayableItemEntity(
    val url: String,
    val clickAreaMode: String,
)
