package com.particles.android.ads.internal.domain

import com.particles.android.ads.internal.util.viewability.OMMediaEvents

class VideoEvents(private val adSession: AdSession, private val omMediaEvents: OMMediaEvents?) {

    fun onVideoStart(duration: Int, latency: Int, extras: Map<String, Any?>? = null) {
        omMediaEvents?.start(duration.toLong(), if (adSession.ad.creative.video?.isMutePlay == true) 0F else 1F)
        val type = TrackingEvent.EVENT_TYPE_VIDEO_START
        if (adSession.adEventTime(type) > 0L) {
            return
        }
        adSession.onAdEvent(type,
            videoExtras = VideoExtras(
                latency = latency,
                duration = duration,
                isAutoPlay = adSession.ad.creative.video?.isAutoPlay ?: false,
                isLoopPlay = adSession.ad.creative.video?.isLoopPlay ?: false,
                isMutePlay = adSession.ad.creative.video?.isMutePlay ?: false,
                isVideoClickable = adSession.ad.creative.video?.isClickable ?: false,
            ),
            extras = extras)
    }

    fun onVideoFirstQuartile(extras: Map<String, Any?>? = null) {
        omMediaEvents?.firstQuartile()
        val type = TrackingEvent.EVENT_TYPE_VIDEO_FIRST_QUARTILE
        if (adSession.adEventTime(type) > 0L) {
            return
        }
        adSession.onAdEvent(type, extras = extras)
    }

    fun onVideoMidpoint(extras: Map<String, Any?>? = null) {
        omMediaEvents?.midpoint()
        val type = TrackingEvent.EVENT_TYPE_VIDEO_MIDPOINT
        if (adSession.adEventTime(type) > 0L) {
            return
        }
        adSession.onAdEvent(type, extras = extras)
    }

    fun onVideoThirdQuartile(extras: Map<String, Any?>? = null) {
        omMediaEvents?.thirdQuartile()
        val type = TrackingEvent.EVENT_TYPE_VIDEO_THIRD_QUARTILE
        if (adSession.adEventTime(type) > 0L) {
            return
        }
        adSession.onAdEvent(type, extras = extras)
    }

    fun onVideoComplete(extras: Map<String, Any?>? = null) {
        omMediaEvents?.complete()
        val type = TrackingEvent.EVENT_TYPE_VIDEO_COMPLETE
        if (adSession.adEventTime(type) > 0L) {
            return
        }
        adSession.onAdEvent(type, extras = extras)
    }

    fun onVideoProgress(offset: Long, extras: Map<String, Any?>? = null) {
        val type = TrackingEvent.EVENT_TYPE_VIDEO_PROGRESS
        if (adSession.adEventTime("$type-$offset") > 0L) {
            return
        }
        adSession.onAdEvent(type, offset = offset, extras = extras)
    }

    fun onVideoMute(extras: Map<String, Any?>? = null) {
        omMediaEvents?.volumeChange(0F)
        adSession.onAdEvent(TrackingEvent.EVENT_TYPE_VIDEO_MUTE, extras = extras)
    }

    fun onVideoUnmute(extras: Map<String, Any?>? = null) {
        omMediaEvents?.volumeChange(1F)
        adSession.onAdEvent(TrackingEvent.EVENT_TYPE_VIDEO_UNMUTE, extras = extras)
    }

    fun onVideoPause(
        reason: String?,
        duration: Int,
        position: Int,
        extras: Map<String, Any?>? = null
    ) {
        omMediaEvents?.pause()
        adSession.onAdEvent(
            TrackingEvent.EVENT_TYPE_VIDEO_PAUSE,
            reason = reason,
            videoProgressExtras = VideoProgressExtras(
                duration = duration,
                position = position,
                repeatCount = adSession.adPlaybackState.repeatCount,
            ),
            extras = extras
        )
    }

    fun onVideoResume(reason: String?, extras: Map<String, Any?>? = null) {
        omMediaEvents?.resume()
        adSession.onAdEvent(TrackingEvent.EVENT_TYPE_VIDEO_RESUME, reason = reason, extras = extras)
    }
}
