package com.particles.android.ads.internal.rendering

import android.content.Context
import android.graphics.Color
import android.util.AttributeSet
import android.webkit.*
import com.particles.android.ads.internal.util.WebViews

class AdWebView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = android.R.attr.webViewStyle
) : BaseWebView(context, attrs, defStyleAttr) {

    var onAdClickThrough: ((url: String) -> Unit)? = null

    init {
        disableScrollBar()

        // screen adaptation
        settings.useWideViewPort = true
        settings.loadWithOverviewMode = true

        // disable zoom
        settings.setSupportZoom(false)

        // support mixed content mode
        settings.mixedContentMode = WebSettings.MIXED_CONTENT_ALWAYS_ALLOW
        setBackgroundColor(Color.TRANSPARENT)

        webViewClient = object: WebViewClient() {
            override fun shouldOverrideUrlLoading(view: WebView?, request: WebResourceRequest?): Boolean {
                if (view != null && request != null && !request.isRedirect && request.hasGesture()) {
                    onAdClickThrough?.invoke(request.url.toString())
                    return true
                }

                return super.shouldOverrideUrlLoading(view, request)
            }

            override fun onRenderProcessGone(view: WebView?, detail: RenderProcessGoneDetail?): Boolean {
                return WebViews.onRenderProcessGone(view, detail)
            }
        }
    }

    fun loadHtml(
        html: String,
        baseUrl: String? = null,
    ) {
        loadDataWithBaseURL(baseUrl, html, null, null, null)
    }

    private fun disableScrollBar() {
        scrollBarStyle = SCROLLBARS_INSIDE_OVERLAY
        isHorizontalScrollBarEnabled = false
        isVerticalScrollBarEnabled = false
    }
}
