package com.particles.android.ads.internal.rendering

import android.content.Context
import android.util.AttributeSet
import android.view.ViewGroup.LayoutParams.MATCH_PARENT
import com.particles.android.ads.banner.BannerAdView
import com.particles.android.ads.internal.domain.AdSession
import com.particles.android.ads.internal.util.viewability.OMSDKUtil
import com.particles.android.ads.internal.util.viewability.OMTracker

class BannerHtmlAdView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : BannerAdView(context, attrs, defStyleAttr) {

    private val webView = AdWebView(context)
    private val omTracker by lazy {
        val adVerifications = adSession?.ad?.creative?.adVerifications
        if (!adVerifications.isNullOrEmpty()) {
            OMTracker.createWebViewDisplayTracker(webView)
        } else null
    }

    init {
        webView.onAdClickThrough = { url -> ad?.onAdClicked(this, url = url) }
        addView(webView, MATCH_PARENT, MATCH_PARENT)
    }

    override fun onRenderAd(adSession: AdSession?) {
        var html = adSession?.ad?.creative?.adm ?: ""
        if (adSession?.ad?.creative?.adVerifications?.isNotEmpty() == true) {
            html = OMSDKUtil.injectScriptContentIntoHtml(context, html)
        }
        webView.loadHtml(html)
    }

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        omTracker?.startTracking()
        omTracker?.trackImpression()
    }

    override fun onDetachedFromWindow() {
        super.onDetachedFromWindow()
        omTracker?.stopTracking()
    }
}
