package com.particles.android.ads.internal.rendering

import android.annotation.SuppressLint
import android.content.Context
import android.util.AttributeSet
import android.view.ViewGroup
import android.webkit.CookieManager
import android.webkit.WebView
import com.particles.android.ads.internal.util.WebViews

abstract class BaseWebView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = android.R.attr.webViewStyle
) : WebView(context, attrs, defStyleAttr) {

    init {
        enableJavascriptCaching()
        restrictDeviceContentAccess()
        WebViews.setDisableJSChromeClient(this)
    }

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        try {
            CookieManager.getInstance().setAcceptThirdPartyCookies(this, true)
        } catch (e: Exception) {
            // ignore
        }
    }

    override fun destroy() {
        (parent as? ViewGroup)?.removeView(this)
        removeAllViews()
        super.destroy()
    }

    @SuppressLint("SetJavaScriptEnabled")
    private fun enableJavascriptCaching() {
        settings.javaScriptCanOpenWindowsAutomatically = false
        settings.javaScriptEnabled = true
        settings.domStorageEnabled = true
    }

    /*
     * Disabling file access and content access prevents advertising creatives from
     * detecting the presence of, or reading, files on the device filesystem.
     */
    private fun restrictDeviceContentAccess() {
        settings.allowFileAccess = false
        settings.allowContentAccess = false
        settings.allowFileAccessFromFileURLs = false
        settings.allowUniversalAccessFromFileURLs = false
    }
}
