package com.particles.android.ads.internal.rendering

import android.graphics.Outline
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.ViewOutlineProvider
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.particles.android.ads.R
import com.particles.android.ads.internal.domain.CarouselItem

class MediaViewCarouselAdapter : RecyclerView.Adapter<MediaViewCarouselViewHolder>() {

    var items: List<CarouselItem>? = null
    var onItemClick: ((view: View, item: CarouselItem, position: Int) -> Unit)? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): MediaViewCarouselViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        val itemView = inflater.inflate(R.layout._nova_native_media_carousel_item, parent, false)
        return MediaViewCarouselViewHolder(itemView)
    }

    override fun onBindViewHolder(holder: MediaViewCarouselViewHolder, position: Int) {
        val item = getItem(position)
        Glide.with(holder.imageView).load(item?.image?.url).into(holder.imageView)
        holder.textView.text = item?.body
        holder.button.text = item?.callToAction
        holder.itemView.setOnClickListener {
            if (item != null) {
                onItemClick?.invoke(it, item, position)
            }
        }
    }

    override fun getItemCount(): Int {
        return items?.size ?: 0
    }

    private fun getItem(position: Int): CarouselItem? {
        items?.let {
            if (position >= 0 && position < it.size) {
                return it[position]
            }
        }
        return null
    }
}

class MediaViewCarouselViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
    val imageView: ImageView = itemView.findViewById(R.id.image)
    val textView: TextView = itemView.findViewById(R.id.text)
    val button: TextView = itemView.findViewById(R.id.button)

    init {
        val density = itemView.resources.displayMetrics.density
        itemView.clipToOutline = true
        imageView.outlineProvider = object : ViewOutlineProvider() {
            override fun getOutline(view: View?, outline: Outline?) {
                if (view != null && outline != null) {
                    outline.setRoundRect(0, 0, view.width,
                        (view.height + 10 * density + 0.5F).toInt(),
                        10 * density
                    )
                }
            }
        }
        imageView.clipToOutline = true
    }
}
