package com.particles.android.ads.internal.rendering

import android.content.Context
import android.graphics.Rect
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.PagerSnapHelper
import androidx.recyclerview.widget.RecyclerView
import com.particles.android.ads.R
import com.particles.android.ads.internal.NativeAdImpl

class MediaViewCarouselRenderer @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : MediaViewRenderer(context, attrs, defStyleAttr) {

    private val recyclerView: RecyclerView
    private val adapter = MediaViewCarouselAdapter()

    init {
        val view = LayoutInflater.from(context).inflate(R.layout._nova_native_media_carousel, this)
        recyclerView = view.findViewById(R.id.carousel_recycler_view)
        initRecyclerView(recyclerView)
    }

    private fun initRecyclerView(recyclerView: RecyclerView) {
        val layoutManager = LinearLayoutManager(recyclerView.context)
        layoutManager.orientation = LinearLayoutManager.HORIZONTAL
        recyclerView.layoutManager = layoutManager

        val density = recyclerView.resources.displayMetrics.density
        val itemDecoration = object: RecyclerView.ItemDecoration() {
            private val margin = (14 * density).toInt()
            override fun getItemOffsets(outRect: Rect, view: View, parent: RecyclerView, state: RecyclerView.State) {
                super.getItemOffsets(outRect, view, parent, state)
                val position = parent.getChildLayoutPosition(view)
                if (position == 0) {
                    outRect.left = margin
                }
                outRect.right = margin
            }
        }
        recyclerView.addItemDecoration(itemDecoration)

        val pagerSnapHelper = PagerSnapHelper()
        pagerSnapHelper.attachToRecyclerView(recyclerView)

        recyclerView.adapter = adapter
    }

    override fun setNativeAd(ad: NativeAdImpl?) {
        adapter.items = ad?.creative?.carouselItems
        adapter.onItemClick = ad?.let {
            {view, item, _ ->
                ad.onAdClicked(view, url = item.clickThroughUrl)
            }
        }
        adapter.notifyDataSetChanged()
    }
}
