package com.particles.android.ads.internal.rendering.fullscreen

import android.content.Context
import android.os.Bundle
import android.view.View
import androidx.activity.OnBackPressedCallback
import androidx.annotation.IdRes
import androidx.annotation.LayoutRes
import androidx.fragment.app.FragmentActivity
import androidx.fragment.app.FragmentManager

interface ActivityDelegate {
    fun onCreate(savedInstanceState: Bundle?) {}
    fun onStart() {}
    fun onResume() {}
    fun onPause() {}
    fun onStop() {}
    fun onDestroy() {}
}

abstract class BaseActivityDelegate(protected val activity: FragmentActivity): ActivityDelegate {
    val context: Context = activity
    val applicationContext: Context = activity.applicationContext
    val supportFragmentManager: FragmentManager = activity.supportFragmentManager

    init {
        activity.onBackPressedDispatcher.addCallback(activity, object : OnBackPressedCallback(true) {
            override fun handleOnBackPressed() {
                onBackPressed()
            }
        })
    }

    fun setContentView(@LayoutRes layoutResID: Int) {
        activity.setContentView(layoutResID)
    }

    open fun <T : View?> findViewById(@IdRes id: Int): T {
        return activity.findViewById<T>(id)
    }

    fun finish() {
        activity.finish()
    }

    open fun onBackPressed() {
        activity.finish()
    }
}
