package com.particles.android.ads.internal.tracking

import com.particles.android.ads.internal.util.OkHttpHolder
import okhttp3.*
import java.io.IOException

abstract class Tracker {

    fun fire(vararg urls: String, transform: (String) -> String = { it }) {
        urls.map { transform(it) }.forEach { fire(it) }
    }

    fun fire(urls: Collection<String>, transform: (String) -> String = { it }) {
        urls.map { transform(it) }.forEach { fire(it) }
    }

    fun fire(url: String) {
        try {
            val request = Request.Builder().url(url).header("User-Agent", OkHttpHolder.httpAgent).build()
            OkHttpHolder.okHttpClient.newCall(request).enqueue(okCallback)
        } catch (e: Exception) {
            // ignore
        }
    }

    companion object {
        private val okCallback by lazy { object : Callback {
            override fun onFailure(call: Call, e: IOException) {}
            override fun onResponse(call: Call, response: Response) {
                response.close()
            }
        } }
    }
}
