package com.particles.android.ads.internal.util

import com.particles.android.ads.BaseAd

object AdBank {

    private data class Entry(
        val key: String,
        val ad: BaseAd,
        val expires: Long,
    )

    private val entries: MutableList<Entry> = mutableListOf()

    fun put(ad: BaseAd, expires: Long = System.currentTimeMillis() + 30_000L): String {
        val key = ad.requestId + '/' + ad.adId
        entries.add(Entry(key, ad, expires))
        return key
    }

    fun get(key: String): BaseAd? {
        trim()
        val entry = entries.firstOrNull { it.key == key }
        entries.remove(entry)
        return entry?.ad
    }

    fun trim() {
        val now = System.currentTimeMillis()
        entries.removeIf { it.expires < now }
    }
}
