package com.particles.android.ads.internal.util

import okhttp3.OkHttpClient
import java.util.concurrent.TimeUnit

object OkHttpHolder {

    val okHttpClient by lazy {
        OkHttpClient.Builder()
            .connectTimeout(4, TimeUnit.SECONDS)
            .writeTimeout(8, TimeUnit.SECONDS)
            .readTimeout(8, TimeUnit.SECONDS)
            .build()
    }

    val httpAgent by lazy { System.getProperty("http.agent") ?: "" }
}