package com.particles.android.ads.internal.util

import android.app.Activity
import android.content.Context
import android.content.res.Configuration
import android.os.Build
import android.view.View

object Themes {
    fun isNightModeActive(context: Context): Boolean {
        val configuration = context.resources.configuration
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            configuration.isNightModeActive
        } else {
            (configuration.uiMode and Configuration.UI_MODE_NIGHT_MASK) == Configuration.UI_MODE_NIGHT_YES
        }
    }

    fun applyTheme(activity: Activity) {
        var flag = View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
        if (!isNightModeActive(activity)) {
            flag = flag or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                flag = flag or View.SYSTEM_UI_FLAG_LIGHT_NAVIGATION_BAR
            }
        }
        activity.window.decorView.systemUiVisibility = flag
    }
}
