package com.particles.android.ads.internal.util

import android.view.ViewGroup
import android.webkit.*
import android.webkit.WebView.HitTestResult


object WebViews {
    fun isDeeplink(uri: String?): Boolean {
        return uri != null
                && !uri.startsWith("http:", ignoreCase = true)
                && !uri.startsWith("https:", ignoreCase = true)
    }

    fun hasGesture(view: WebView?): Boolean {
        val htr = view?.hitTestResult
        return htr != null && (HitTestResult.SRC_ANCHOR_TYPE == htr.type
                || HitTestResult.SRC_IMAGE_ANCHOR_TYPE == htr.type) && htr.extra != null
    }

    fun setDisableJSChromeClient(webView: WebView) {
        webView.webChromeClient = object : WebChromeClient() {
            override fun onJsAlert(
                view: WebView, url: String,
                message: String, result: JsResult
            ): Boolean {
                result.confirm()
                return true
            }

            override fun onJsConfirm(
                view: WebView, url: String,
                message: String, result: JsResult
            ): Boolean {
                result.confirm()
                return true
            }

            override fun onJsPrompt(
                view: WebView, url: String,
                message: String, defaultValue: String,
                result: JsPromptResult
            ): Boolean {
                result.confirm()
                return true
            }

            override fun onJsBeforeUnload(
                view: WebView, url: String,
                message: String, result: JsResult
            ): Boolean {
                result.confirm()
                return true
            }
        }
    }

    fun getPageIndex(webView: WebView): Int {
        if (!webView.canGoBack()) {
            return 0
        }

        return webView.copyBackForwardList().currentIndex
    }

    fun getScrollDepth(webView: WebView): Float {
        return webView.scrollY / (webView.contentHeight * webView.scale - webView.height)
    }

    fun onRenderProcessGone(view: WebView?, detail: RenderProcessGoneDetail?): Boolean {
        view?.let {
            (it.parent as? ViewGroup)?.removeView(view)
            view.destroy()
        }
        return true
    }

}
