package com.particles.android.ads.internal.util.viewability;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.webkit.WebView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.iab.omid.library.newsbreak1.Omid;
import com.iab.omid.library.newsbreak1.ScriptInjector;
import com.iab.omid.library.newsbreak1.adsession.AdSession;
import com.iab.omid.library.newsbreak1.adsession.AdSessionConfiguration;
import com.iab.omid.library.newsbreak1.adsession.AdSessionContext;
import com.iab.omid.library.newsbreak1.adsession.CreativeType;
import com.iab.omid.library.newsbreak1.adsession.FriendlyObstructionPurpose;
import com.iab.omid.library.newsbreak1.adsession.ImpressionType;
import com.iab.omid.library.newsbreak1.adsession.Owner;
import com.iab.omid.library.newsbreak1.adsession.Partner;
import com.iab.omid.library.newsbreak1.adsession.VerificationScriptResource;
import com.particles.android.ads.R;
import com.particles.android.ads.internal.NovaInternal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class OMSDKUtil {

    private static final String PARTNER_NAME = "Newsbreak1";

    public static String injectScriptContentIntoHtml(Context context, String html) {
        try {
            String omidJs = getOmidJs(context);
            return ScriptInjector.injectScriptContentIntoHtml(omidJs, html);
        } catch (Exception e) {
            return html;
        }
    }

    @Nullable
    public static AdSession createHtmlAdSession(WebView webView) {
        Omid.activate(webView.getContext());
        if (!Omid.isActive()) {
            return null;
        }

        Partner partner = Partner.createPartner(PARTNER_NAME, NovaInternal.INSTANCE.getAppVersion());

        AdSessionContext adSessionContext =
                AdSessionContext.createHtmlAdSessionContext(partner, webView, "", "");

        AdSessionConfiguration adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration(
                CreativeType.HTML_DISPLAY,
                ImpressionType.BEGIN_TO_RENDER,
                Owner.NATIVE,
                Owner.NONE,
                false);

        return AdSession.createAdSession(adSessionConfiguration, adSessionContext);
    }

    @Nullable
    public static AdSession createNativeAdSession(Context applicationContext, List<String> verificationResourceUrls) {
        Omid.activate(applicationContext);
        if (!Omid.isActive()) {
            return null;
        }

        AdSessionConfiguration adSessionConfiguration =
                AdSessionConfiguration.createAdSessionConfiguration(CreativeType.NATIVE_DISPLAY, ImpressionType.VIEWABLE, Owner.NATIVE,
                        Owner.NONE, false);
        try {
            Partner partner = Partner.createPartner(PARTNER_NAME, NovaInternal.INSTANCE.getAppVersion());
            final String omidJs = getOmidJs(applicationContext);
            List<VerificationScriptResource> verificationScripts = getVerificationScriptResources(verificationResourceUrls);
            AdSessionContext adSessionContext = AdSessionContext.createNativeAdSessionContext(partner, omidJs, verificationScripts, null, "");
            return AdSession.createAdSession(adSessionConfiguration, adSessionContext);
        } catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static AdSession createNativeVideoSession(Context applicationContext, List<String> verificationResourceUrls) {
        Omid.activate(applicationContext);
        if (!Omid.isActive()) {
            return null;
        }

        AdSessionConfiguration adSessionConfiguration =
                AdSessionConfiguration.createAdSessionConfiguration(CreativeType.VIDEO, ImpressionType.BEGIN_TO_RENDER, Owner.NATIVE,
                        Owner.NATIVE, false);
        try {
            Partner partner = Partner.createPartner(PARTNER_NAME, NovaInternal.INSTANCE.getAppVersion());
            final String omidJs = getOmidJs(applicationContext);
            List<VerificationScriptResource> verificationScripts = getVerificationScriptResources(verificationResourceUrls);
            AdSessionContext adSessionContext = AdSessionContext.createNativeAdSessionContext(partner, omidJs, verificationScripts, null, "");
            return AdSession.createAdSession(adSessionConfiguration, adSessionContext);
        } catch (IOException e) {
            return null;
        }
    }

    private static String getOmidJs(Context applicationContext) throws IOException {
        Resources res = applicationContext.getResources();
        // load IAB OM SDK JavaScript file
        InputStream inputStream = res.openRawResource(R.raw.omsdk_v1_4_10);
        byte[] b = new byte[inputStream.available()];
        final int bytesRead = inputStream.read(b);
        return new String(b, 0, bytesRead, "UTF-8");
    }

    @NonNull
    private static List<VerificationScriptResource> getVerificationScriptResources(List<String> verificationResourceUrls)
            throws MalformedURLException {
        List<VerificationScriptResource> verificationScriptResources = new ArrayList<>();
        if (verificationResourceUrls != null) {
            for (String url : verificationResourceUrls) {
                VerificationScriptResource verificationScriptResource =
                        VerificationScriptResource.createVerificationScriptResourceWithoutParameters(new URL(url));
                verificationScriptResources.add(verificationScriptResource);
            }
        }
        return verificationScriptResources;
    }

    public static void addFriendlyObstructions(View adView, AdSession adSession) {
//        TODO:
//        Context context = getActivityContext(adView);
//        if (context instanceof NewsDetailActivity) {
//            View view = ((Activity) context).findViewById(R.id.bottom_bar_layout);
//            if (view != null) {
//                adSession.addFriendlyObstruction(view, FriendlyObstructionPurpose.NOT_VISIBLE, "transparent overlay");
//            }
//        }
    }

    private static Context getActivityContext(View view) {
        for (View v = view; v != null && v.getParent() instanceof View; v = (View) v.getParent()) {
            Context context = v.getContext();
            if (context instanceof Activity) {
                return context;
            }
        }

        return null;
    }
}
