package com.particles.android.ads.internal.util.viewability

internal class VisibleTimeCounter(vararg thresholds: Int) {
    private val thresholds = thresholds.asList()
    private val visibleTimes = LongArray(thresholds.size)
    private val startedTimes = LongArray(thresholds.size)

    fun reset() {
        visibleTimes.fill(0L, 0)
        startedTimes.fill(0L, 0)
    }

    fun update(percent: Int, updatedAt: Long = System.currentTimeMillis()): Boolean {
        var changed = false

        thresholds.forEachIndexed { index, threshold ->
            if (percent < threshold) {
                if (startedTimes[index] > 0) {
                    changed = changed or compareAndSetMaxValue(
                        visibleTimes, index, updatedAt - startedTimes[index])
                    startedTimes[index] = 0
                }
            } else {
                if (startedTimes[index] > 0) {
                    changed = changed or compareAndSetMaxValue(
                        visibleTimes, index, updatedAt - startedTimes[index])
                } else {
                    startedTimes[index] = updatedAt
                }
            }
        }

        return changed
    }

    fun getVisibleTime(threshold: Int): Long {
        val index = thresholds.indexOf(threshold)
        if (index >= 0) {
            return visibleTimes[index]
        }
        return 0
    }

    private fun compareAndSetMaxValue(array: LongArray, index: Int, newValue: Long): Boolean {
        if (index >= 0 && index < array.size && newValue > array[index]) {
            array[index] = newValue
            return true
        }
        return false
    }
}
