package com.particles.android.ads.nativead

import android.content.Context
import android.util.AttributeSet
import android.view.Gravity
import android.view.ViewGroup.LayoutParams.MATCH_PARENT
import android.view.ViewGroup.LayoutParams.WRAP_CONTENT
import android.widget.FrameLayout
import android.widget.ImageView
import com.particles.android.ads.internal.NativeAdImpl
import com.particles.android.ads.internal.rendering.MediaViewCarouselRenderer
import com.particles.android.ads.internal.rendering.MediaViewImageRenderer
import com.particles.android.ads.internal.rendering.MediaViewRenderer
import com.particles.android.ads.internal.rendering.MediaViewVideoRenderer
import com.particles.android.ads.internal.util.viewability.OMMediaEvents
import com.particles.android.ads.nativead.NativeAd.CreativeType.*

class MediaView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : FrameLayout(context, attrs, defStyleAttr) {

    private var renderer: MediaViewRenderer? = null
    private var imageScaleType: ImageView.ScaleType = ImageView.ScaleType.FIT_CENTER
    private var useController = true

    var custom = false

    fun setNativeAd(ad: NativeAd?, omMediaEvents: OMMediaEvents? = null) {
        if (custom) {
            return
        }

        if (ad is NativeAdImpl) {
            val renderer = when (ad.creativeType) {
                CAROUSEL -> getCarouselRenderer()
                VIDEO -> getVideoRenderer()
                IMAGE, SPONSORED_IMAGE, UNKNOWN -> getImageRenderer()
            }
            renderer.setNativeAd(ad, omMediaEvents)
        }
    }

    fun setImageScaleType(scaleType: ImageView.ScaleType) {
        imageScaleType = scaleType
        if (renderer is MediaViewImageRenderer) {
            (renderer as MediaViewImageRenderer).setImageScaleType(scaleType)
        }
    }

    fun setUseController(useController: Boolean) {
        this.useController = useController
        if (renderer is MediaViewVideoRenderer) {
            (renderer as MediaViewVideoRenderer).setUseController(useController)
        }
    }

    private fun getCarouselRenderer(): MediaViewCarouselRenderer {
        if (renderer is MediaViewCarouselRenderer) {
            return renderer as MediaViewCarouselRenderer
        }

        if (renderer != null) {
            super.removeView(renderer)
        }

        renderer = MediaViewCarouselRenderer(context)
        super.addView(renderer, LayoutParams(WRAP_CONTENT, WRAP_CONTENT, Gravity.CENTER))
        return renderer as MediaViewCarouselRenderer
    }

    private fun getVideoRenderer(): MediaViewVideoRenderer {
        if (renderer is MediaViewVideoRenderer) {
            return renderer as MediaViewVideoRenderer
        }

        if (renderer != null) {
            super.removeView(renderer)
        }

        renderer = MediaViewVideoRenderer(context).also {
            it.setUseController(useController)
        }
        super.addView(renderer, LayoutParams(WRAP_CONTENT, WRAP_CONTENT, Gravity.CENTER))
        return renderer as MediaViewVideoRenderer
    }

    private fun getImageRenderer(): MediaViewImageRenderer {
        if (renderer is MediaViewImageRenderer) {
            return renderer as MediaViewImageRenderer
        }

        if (renderer != null) {
            super.removeView(renderer)
        }

        renderer = MediaViewImageRenderer(context).also {
            it.setImageScaleType(imageScaleType)
        }
        super.addView(renderer, LayoutParams(WRAP_CONTENT, WRAP_CONTENT, Gravity.CENTER))
        return renderer as MediaViewImageRenderer
    }

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        renderer?.layoutParams?.let {
            it.width = when (MeasureSpec.getMode(widthMeasureSpec)) {
                MeasureSpec.EXACTLY -> MATCH_PARENT
                else -> WRAP_CONTENT
            }
            it.height = when (MeasureSpec.getMode(heightMeasureSpec)) {
                MeasureSpec.EXACTLY -> MATCH_PARENT
                else -> WRAP_CONTENT
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec)
    }
}
