package com.particles.android.ads.nativead

import com.particles.android.ads.BaseAd

interface NativeAd : BaseAd {
    val creativeType: CreativeType
    val headline: String?
    val body: String?
    val icon: Image?
    val images: List<Image?>?
    val callToAction: String?
    val advertiser: String?
    val starRating: Double?
    val addon: Addon?
    val mediaLayoutType: MediaLayoutType
    var mediaListener: MediaListener?
    var addonListener: AddonListener?
    fun setAdListener(listener: NativeAdListener)
    fun destroy()

    fun onAdHidden(reason: String?)
    fun onAdUnhidden()

    enum class CreativeType {
        IMAGE,
        VIDEO,
        CAROUSEL,
        SPONSORED_IMAGE,
        UNKNOWN,
    }

    enum class MediaLayoutType {
        HORIZONTAL,
        VERTICAL,
        VERTICAL_NO_TEXT,
        INTER_SCROLLER,
        TALLER,
    }

    interface Image {
        val uri: String?
        val width: Int
        val height: Int
    }

    interface Addon {
        val duration: Int
    }
}
