package com.particles.prebidadapter

import com.particles.msp.AdNetworkAdapterProvider
import com.particles.msp.adapter.AdNetwork
import com.particles.msp.adapter.AdNetworkAdapter

class AdNetworkAdapterProviderImp: AdNetworkAdapterProvider {
    private val GOOGLE_ADAPTER_CLASS_NAME = "com.particles.googleadapter.GoogleAdapter"
    private val PREBID_ADAPTER_CLASS_NAME = "com.particles.prebidadapter.PrebidAdapter"
    private val FACEBOOK_ADAPTER_CLASS_NAME = "com.particles.facebookadapter.FacebookAdapter"
    private val NOVA_ADAPTER_CLASS_NAME = "com.particles.novaadapter.NovaAdapter"

    override fun getAdNetworkAdapter(adNetwork: AdNetwork): AdNetworkAdapter {
        val classStr: String = when (adNetwork) {
            AdNetwork.Google -> GOOGLE_ADAPTER_CLASS_NAME
            AdNetwork.Prebid -> PREBID_ADAPTER_CLASS_NAME
            AdNetwork.Facebook -> FACEBOOK_ADAPTER_CLASS_NAME
            AdNetwork.Nova -> NOVA_ADAPTER_CLASS_NAME
            else -> "Unknown"
        }
        return createInstance(classStr) as AdNetworkAdapter
    }

    override fun getAdNetworkAdaptersCount(): Int {
        val adapterClassNames = arrayOf(GOOGLE_ADAPTER_CLASS_NAME, PREBID_ADAPTER_CLASS_NAME, FACEBOOK_ADAPTER_CLASS_NAME, NOVA_ADAPTER_CLASS_NAME)
        return adapterClassNames.count {
            createInstance(it) != null
        }
    }
}