package com.particles.prebidadapter

import android.content.Context
import com.particles.mes.android.MesTracker
import com.particles.mes.android.MesTrackerExt
import com.particles.mes.android.MesTrackerExt.trackAdImpression
import com.particles.msp.adapter.AdNetwork
import com.particles.msp.adapter.AdNetworkAdapter
import com.particles.msp.adapter.AdapterInitListener
import com.particles.msp.adapter.AdapterInitStatus
import com.particles.msp.adapter.InitializationParameters
import com.particles.msp.api.AdListener
import com.particles.msp.api.AdRequest
import com.particles.msp.api.BannerAdView
import com.particles.msp.api.NativeAd
import org.prebid.mobile.AdSize
import org.prebid.mobile.Host
import org.prebid.mobile.PrebidMobile
import org.prebid.mobile.api.exceptions.AdException
import org.prebid.mobile.api.exceptions.InitError
import org.prebid.mobile.api.rendering.BannerView
import org.prebid.mobile.api.rendering.listeners.BannerViewListener
import org.prebid.mobile.rendering.bidding.data.bid.BidResponse
import org.prebid.mobile.rendering.listeners.SdkInitializationListener

class PrebidAdapter : AdNetworkAdapter() {
    private var bannerView: BannerView? = null

    override fun loadAdCreative(bidResponse: Any, adListener: AdListener, context: Any, adRequest: AdRequest) {
        if (bidResponse !is BidResponse || context !is Context) {
            adListener.onError("Failed to load prebid Ad: bidResponse or context is missing")
            return
        }
        // Assuming all other bidders are banner format.
        // may need to add prebid native format support later.
        var adSize = AdSize(320, 50)
        adRequest.adSize?.let {
            adSize = AdSize(it.width, it.height)
        }
        val bannerView = BannerView(context, adRequest.placementId, adSize)
        this.bannerView = bannerView
        bannerView.bidResponse = bidResponse
        bannerView.setBannerListener(object : BannerViewListener {
            override fun onBidResponse(bannerView: BannerView?) {}

            override fun onAdLoaded(bannerView: BannerView?) {
                mspAd?.apply { adInfo["ad_loaded_at"] = System.currentTimeMillis() }
            }

            override fun onAdDisplayed(bannerView: BannerView?) {
                mspAd?.let {
                    mesTracker?.trackAdImpression(adRequest, bidResponse.winningBid, it)
                    handleAdImpression(adListener, adRequest)
                }
            }

            override fun onAdFailed(bannerView: BannerView?, exception: AdException?) {}

            override fun onAdClicked(bannerView: BannerView?) {
                handleAdClicked(adListener, adRequest)
            }

            override fun onAdClosed(bannerView: BannerView?) {}
        })
        bannerView.requestAd()
        val bannerAdView = BannerAdView(bannerView, this)
        bidResponse?.winningBid?.price?.let {
            bannerAdView.adInfo["price"] = it
        }
        handleAdLoaded(bannerAdView, adListener, adRequest)
    }

    override fun prepareViewForInteraction(nativeAd: NativeAd, nativeAdView: Any) {
    }

    override fun destroyAd() {
        bannerView?.setBannerListener(null)
        bannerView?.destroy()
    }

    override fun initialize(
        initParams: InitializationParameters,
        adapterInitListener: AdapterInitListener,
        context: Any?
    ) {
        mesTracker = MesTrackerExt.tracker
        // Prebid SDk must be initialized in UI main thread.
        PrebidMobile.setPrebidServerAccountId(initParams.getPrebidAPIKey())
        Host.CUSTOM.hostUrl = initParams.getPrebidHostUrl()
        PrebidMobile.setPrebidServerHost(Host.CUSTOM)
        PrebidMobile.setShareGeoLocation(true)
        PrebidMobile.setTimeoutMillis(10000)
        PrebidMobile.initializeSdk(context as Context, object : SdkInitializationListener {
            override fun onSdkInit() {
                adapterInitListener.onComplete(AdNetwork.Prebid, AdapterInitStatus.SUCCESS, AdapterInitStatus.SUCCESS.message)
                //AdLogger.i("Prebid SDK is initialized")
            }

            override fun onSdkFailedToInit(error: InitError?) {
                //AdLogger.e("Prebid SDK failed to be initialized: " + (error?.toString() ?: ""))
            }
        })
        //if (!NBBuild.isProduct()) {
        //    PrebidMobile.setLogLevel(
        //}
    }

    companion object {
        private var mesTracker: MesTracker? = null
    }
}
